/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;

public class TbAlarmResult {
    boolean isCreated;
    boolean isUpdated;
    boolean isSeverityUpdated;
    boolean isCleared;
    Alarm alarm;

    public TbAlarmResult(boolean isCreated, boolean isUpdated, boolean isCleared, Alarm alarm) {
        this.isCreated = isCreated;
        this.isUpdated = isUpdated;
        this.isCleared = isCleared;
        this.alarm = alarm;
    }

    public static TbAlarmResult fromAlarmResult(AlarmApiCallResult result) {
        boolean isSeverityChanged = result.isSeverityChanged();
        return new TbAlarmResult(result.isCreated(), result.isModified() && !isSeverityChanged, isSeverityChanged, result.isCleared(), (Alarm)result.getAlarm());
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public boolean isSeverityUpdated() {
        return this.isSeverityUpdated;
    }

    public boolean isCleared() {
        return this.isCleared;
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public void setCreated(boolean isCreated) {
        this.isCreated = isCreated;
    }

    public void setUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated;
    }

    public void setSeverityUpdated(boolean isSeverityUpdated) {
        this.isSeverityUpdated = isSeverityUpdated;
    }

    public void setCleared(boolean isCleared) {
        this.isCleared = isCleared;
    }

    public void setAlarm(Alarm alarm) {
        this.alarm = alarm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbAlarmResult)) {
            return false;
        }
        TbAlarmResult other = (TbAlarmResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCreated() != other.isCreated()) {
            return false;
        }
        if (this.isUpdated() != other.isUpdated()) {
            return false;
        }
        if (this.isSeverityUpdated() != other.isSeverityUpdated()) {
            return false;
        }
        if (this.isCleared() != other.isCleared()) {
            return false;
        }
        Alarm this$alarm = this.getAlarm();
        Alarm other$alarm = other.getAlarm();
        return !(this$alarm == null ? other$alarm != null : !this$alarm.equals(other$alarm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbAlarmResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCreated() ? 79 : 97);
        result = result * 59 + (this.isUpdated() ? 79 : 97);
        result = result * 59 + (this.isSeverityUpdated() ? 79 : 97);
        result = result * 59 + (this.isCleared() ? 79 : 97);
        Alarm $alarm = this.getAlarm();
        result = result * 59 + ($alarm == null ? 43 : $alarm.hashCode());
        return result;
    }

    public String toString() {
        return "TbAlarmResult(isCreated=" + this.isCreated() + ", isUpdated=" + this.isUpdated() + ", isSeverityUpdated=" + this.isSeverityUpdated() + ", isCleared=" + this.isCleared() + ", alarm=" + this.getAlarm() + ")";
    }

    @ConstructorProperties(value={"isCreated", "isUpdated", "isSeverityUpdated", "isCleared", "alarm"})
    public TbAlarmResult(boolean isCreated, boolean isUpdated, boolean isSeverityUpdated, boolean isCleared, Alarm alarm) {
        this.isCreated = isCreated;
        this.isUpdated = isUpdated;
        this.isSeverityUpdated = isSeverityUpdated;
        this.isCleared = isCleared;
        this.alarm = alarm;
    }
}

