/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityFieldsData;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;

public class EntitiesFieldsAsyncLoader {
    public static ListenableFuture<EntityFieldsData> findAsync(TbContext ctx, EntityId original) {
        switch (original.getEntityType()) {
            case TENANT: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getTenantService().findTenantByIdAsync(ctx.getTenantId(), (TenantId)original), EntityFieldsData::new);
            }
            case CUSTOMER: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), (CustomerId)original), EntityFieldsData::new);
            }
            case USER: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), (UserId)original), EntityFieldsData::new);
            }
            case ASSET: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), (AssetId)original), EntityFieldsData::new);
            }
            case DEVICE: {
                return EntitiesFieldsAsyncLoader.getAsync(Futures.immediateFuture((Object)ctx.getDeviceService().findDeviceById(ctx.getTenantId(), (DeviceId)original)), EntityFieldsData::new);
            }
            case ALARM: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), (AlarmId)original), EntityFieldsData::new);
            }
            case RULE_CHAIN: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getRuleChainService().findRuleChainByIdAsync(ctx.getTenantId(), (RuleChainId)original), EntityFieldsData::new);
            }
            case ENTITY_VIEW: {
                return EntitiesFieldsAsyncLoader.getAsync(ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), (EntityViewId)original), EntityFieldsData::new);
            }
        }
        return Futures.immediateFailedFuture((Throwable)new TbNodeException("Unexpected original EntityType " + original.getEntityType()));
    }

    private static <T extends BaseData> ListenableFuture<EntityFieldsData> getAsync(ListenableFuture<T> future, Function<T, EntityFieldsData> converter) {
        return Futures.transformAsync(future, in -> in != null ? Futures.immediateFuture((Object)((EntityFieldsData)converter.apply(in))) : Futures.immediateFailedFuture((Throwable)new RuntimeException("Entity not found!")), (Executor)MoreExecutors.directExecutor());
    }
}

