/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.MultipleTbMsgsCallbackWrapper;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;

@RuleNode(type=ComponentType.TRANSFORMATION, name="split array msg", configClazz=EmptyNodeConfiguration.class, nodeDescription="Split array message into several msgs", nodeDetails="Split the array fetched from the msg body. If the msg data is not a JSON array returns the incoming message as outbound message with <code>Failure</code> chain, otherwise returns inner objects of the extracted array as separate messages via <code>Success</code> chain.", uiResources={"static/rulenode/rulenode-core-config.js"}, icon="content_copy", configDirective="tbNodeEmptyConfig")
public class TbSplitArrayMsgNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbSplitArrayMsgNode.class);
    private EmptyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (EmptyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, EmptyNodeConfiguration.class);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        JsonNode jsonNode = JacksonUtil.toJsonNode((String)msg.getData());
        if (jsonNode.isArray()) {
            ArrayNode data = (ArrayNode)jsonNode;
            if (data.isEmpty()) {
                ctx.ack(msg);
            } else if (data.size() == 1) {
                ctx.tellSuccess(TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)msg.getOriginator(), (TbMsgMetaData)msg.getMetaData(), (String)JacksonUtil.toString((Object)data.get(0))));
            } else {
                MultipleTbMsgsCallbackWrapper wrapper = new MultipleTbMsgsCallbackWrapper(data.size(), new TbMsgCallback(){

                    public void onSuccess() {
                        ctx.ack(msg);
                    }

                    public void onFailure(RuleEngineException e) {
                        ctx.tellFailure(msg, (Throwable)e);
                    }
                });
                data.forEach(msgNode -> ctx.enqueueForTellNext(TbMsg.newMsg((String)msg.getQueueName(), (String)msg.getType(), (EntityId)msg.getOriginator(), (TbMsgMetaData)msg.getMetaData(), (String)JacksonUtil.toString((Object)msgNode)), TbRelationTypes.SUCCESS, wrapper::onSuccess, wrapper::onFailure));
            }
        } else {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Msg data is not a JSON Array!"));
        }
    }
}

