/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbRenameKeysNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="rename keys", configClazz=TbRenameKeysNodeConfiguration.class, nodeDescription="Renames msg data or metadata keys to the new key names selected in the key mapping.", nodeDetails="If the key that is selected in the key mapping is missed in the selected msg source(data or metadata), it will be ignored. Returns transformed messages via <code>Success</code> chain", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeRenameKeysConfig", icon="find_replace")
public class TbRenameKeysNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbRenameKeysNode.class);
    private TbRenameKeysNodeConfiguration config;
    private Map<String, String> renameKeysMapping;
    private boolean fromMetadata;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbRenameKeysNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbRenameKeysNodeConfiguration.class);
        this.renameKeysMapping = this.config.getRenameKeysMapping();
        this.fromMetadata = this.config.isFromMetadata();
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsgMetaData metaData = msg.getMetaData();
        String data = msg.getData();
        boolean msgChanged = false;
        if (this.fromMetadata) {
            Map metaDataMap = metaData.getData();
            for (Map.Entry<String, String> entry : this.renameKeysMapping.entrySet()) {
                String nameKey = entry.getKey();
                if (!metaDataMap.containsKey(nameKey)) continue;
                msgChanged = true;
                metaDataMap.put(entry.getValue(), (String)metaDataMap.get(nameKey));
                metaDataMap.remove(nameKey);
            }
            metaData = new TbMsgMetaData(metaDataMap);
        } else {
            JsonNode dataNode = JacksonUtil.toJsonNode((String)msg.getData());
            if (dataNode.isObject()) {
                ObjectNode msgData = (ObjectNode)dataNode;
                for (Map.Entry<String, String> entry : this.renameKeysMapping.entrySet()) {
                    String nameKey = entry.getKey();
                    if (!msgData.has(nameKey)) continue;
                    msgChanged = true;
                    msgData.set(entry.getValue(), msgData.get(nameKey));
                    msgData.remove(nameKey);
                }
                data = JacksonUtil.toString((Object)msgData);
            }
        }
        if (msgChanged) {
            ctx.tellSuccess(TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)msg.getOriginator(), (TbMsgMetaData)metaData, (String)data));
        } else {
            ctx.tellSuccess(msg);
        }
    }
}

