/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbJsonPathNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="json path", configClazz=TbJsonPathNodeConfiguration.class, nodeDescription="Transforms incoming message body using JSONPath expression.", nodeDetails="JSONPath expression specifies a path to an element or a set of elements in a JSON structure. <br/><b>'$'</b> represents the root object or array. <br/>If JSONPath expression evaluation failed, incoming message routes via <code>Failure</code> chain, otherwise <code>Success</code> chain is used.", uiResources={"static/rulenode/rulenode-core-config.js"}, icon="functions", configDirective="tbTransformationNodeJsonPathConfig")
public class TbJsonPathNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbJsonPathNode.class);
    private TbJsonPathNodeConfiguration config;
    private Configuration configurationJsonPath;
    private JsonPath jsonPath;
    private String jsonPathValue;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbJsonPathNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbJsonPathNodeConfiguration.class);
        this.jsonPathValue = this.config.getJsonPath();
        if (!"$".equals(this.jsonPathValue)) {
            this.configurationJsonPath = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
            this.jsonPath = JsonPath.compile((String)this.config.getJsonPath(), (Predicate[])new Predicate[0]);
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        if (!"$".equals(this.jsonPathValue)) {
            try {
                Object jsonPathData = this.jsonPath.read(msg.getData(), this.configurationJsonPath);
                ctx.tellSuccess(TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)msg.getOriginator(), (TbMsgMetaData)msg.getMetaData(), (String)JacksonUtil.toString((Object)jsonPathData)));
            }
            catch (PathNotFoundException e) {
                ctx.tellFailure(msg, (Throwable)e);
            }
        } else {
            ctx.tellSuccess(msg);
        }
    }
}

