/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbDeleteKeysNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="delete keys", configClazz=TbDeleteKeysNodeConfiguration.class, nodeDescription="Removes keys from the msg data or metadata with the specified key names selected in the list", nodeDetails="Will fetch fields (regex) values specified in list. If specified field (regex) is not part of msg or metadata fields it will be ignored. Returns transformed messages via <code>Success</code> chain", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeDeleteKeysConfig", icon="remove_circle")
public class TbDeleteKeysNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbDeleteKeysNode.class);
    private TbDeleteKeysNodeConfiguration config;
    private List<Pattern> patternKeys;
    private boolean fromMetadata;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDeleteKeysNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDeleteKeysNodeConfiguration.class);
        this.fromMetadata = this.config.isFromMetadata();
        this.patternKeys = new ArrayList<Pattern>();
        this.config.getKeys().forEach(key -> this.patternKeys.add(Pattern.compile(key)));
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsgMetaData metaData = msg.getMetaData();
        String msgData = msg.getData();
        ArrayList keysToDelete = new ArrayList();
        if (this.fromMetadata) {
            Map metaDataMap = metaData.getData();
            metaDataMap.forEach((keyMetaData, valueMetaData) -> {
                if (this.checkKey((String)keyMetaData)) {
                    keysToDelete.add(keyMetaData);
                }
            });
            keysToDelete.forEach(key -> metaDataMap.remove(key));
            metaData = new TbMsgMetaData(metaDataMap);
        } else {
            JsonNode dataNode = JacksonUtil.toJsonNode((String)msgData);
            if (dataNode.isObject()) {
                ObjectNode msgDataObject = (ObjectNode)dataNode;
                dataNode.fields().forEachRemaining(entry -> {
                    String keyData = (String)entry.getKey();
                    if (this.checkKey(keyData)) {
                        keysToDelete.add(keyData);
                    }
                });
                msgDataObject.remove(keysToDelete);
                msgData = JacksonUtil.toString((Object)msgDataObject);
            }
        }
        if (keysToDelete.isEmpty()) {
            ctx.tellSuccess(msg);
        } else {
            ctx.tellSuccess(TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)msg.getOriginator(), (TbMsgMetaData)metaData, (String)msgData));
        }
    }

    boolean checkKey(String key) {
        return this.patternKeys.stream().anyMatch(pattern -> pattern.matcher(key).matches());
    }
}

