/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbCopyKeysNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="copy keys", configClazz=TbCopyKeysNodeConfiguration.class, nodeDescription="Copies the msg or metadata keys with specified key names selected in the list", nodeDetails="Will fetch fields values specified in list. If specified field is not part of msg or metadata fields it will be ignored.Returns transformed messages via <code>Success</code> chain", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeCopyKeysConfig", icon="content_copy")
public class TbCopyKeysNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCopyKeysNode.class);
    private TbCopyKeysNodeConfiguration config;
    private List<Pattern> patternKeys;
    private boolean fromMetadata;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCopyKeysNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCopyKeysNodeConfiguration.class);
        this.fromMetadata = this.config.isFromMetadata();
        this.patternKeys = new ArrayList<Pattern>();
        this.config.getKeys().forEach(key -> this.patternKeys.add(Pattern.compile(key)));
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsgMetaData metaData = msg.getMetaData();
        String msgData = msg.getData();
        boolean msgChanged = false;
        JsonNode dataNode = JacksonUtil.toJsonNode((String)msgData);
        if (dataNode.isObject()) {
            if (this.fromMetadata) {
                ObjectNode msgDataNode = (ObjectNode)dataNode;
                Map metaDataMap = metaData.getData();
                for (Map.Entry entry : metaDataMap.entrySet()) {
                    String keyData = (String)entry.getKey();
                    if (!this.checkKey(keyData)) continue;
                    msgChanged = true;
                    msgDataNode.put(keyData, (String)entry.getValue());
                }
                msgData = JacksonUtil.toString((Object)msgDataNode);
            } else {
                Iterator iteratorNode = dataNode.fields();
                while (iteratorNode.hasNext()) {
                    Map.Entry entry = (Map.Entry)iteratorNode.next();
                    String keyData = (String)entry.getKey();
                    if (!this.checkKey(keyData)) continue;
                    msgChanged = true;
                    metaData.putValue(keyData, JacksonUtil.toString(entry.getValue()));
                }
            }
        }
        if (msgChanged) {
            ctx.tellSuccess(TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)msg.getOriginator(), (TbMsgMetaData)metaData, (String)msgData));
        } else {
            ctx.tellSuccess(msg);
        }
    }

    boolean checkKey(String key) {
        return this.patternKeys.stream().anyMatch(pattern -> pattern.matcher(key).matches());
    }
}

