/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractTransformNode;
import org.thingsboard.rule.engine.transform.TbChangeOriginatorNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesAlarmOriginatorIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesByNameAndTypeLoader;
import org.thingsboard.rule.engine.util.EntitiesCustomerIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.TRANSFORMATION, name="change originator", configClazz=TbChangeOriginatorNodeConfiguration.class, nodeDescription="Change Message Originator To Tenant/Customer/Related Entity/Alarm Originator", nodeDetails="Related Entity found using configured relation direction and Relation Type. If multiple Related Entities are found, only first Entity is used as new Originator, other entities are discarded.<br/>Alarm Originator found only in case original Originator is <code>Alarm</code> entity.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeChangeOriginatorConfig", icon="find_replace")
public class TbChangeOriginatorNode
extends TbAbstractTransformNode {
    private static final Logger log = LoggerFactory.getLogger(TbChangeOriginatorNode.class);
    protected static final String CUSTOMER_SOURCE = "CUSTOMER";
    protected static final String TENANT_SOURCE = "TENANT";
    protected static final String RELATED_SOURCE = "RELATED";
    protected static final String ALARM_ORIGINATOR_SOURCE = "ALARM_ORIGINATOR";
    protected static final String ENTITY_SOURCE = "ENTITY";
    private TbChangeOriginatorNodeConfiguration config;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbChangeOriginatorNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbChangeOriginatorNodeConfiguration.class);
        this.validateConfig(this.config);
        this.setConfig(this.config);
    }

    @Override
    protected ListenableFuture<List<TbMsg>> transform(TbContext ctx, TbMsg msg) {
        ListenableFuture<? extends EntityId> newOriginator = this.getNewOriginator(ctx, msg);
        return Futures.transform(newOriginator, n -> {
            if (n == null || n.isNullUid()) {
                return null;
            }
            return Collections.singletonList(ctx.transformMsg(msg, msg.getType(), n, msg.getMetaData(), msg.getData()));
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<? extends EntityId> getNewOriginator(TbContext ctx, TbMsg msg) {
        switch (this.config.getOriginatorSource()) {
            case "CUSTOMER": {
                return EntitiesCustomerIdAsyncLoader.findEntityIdAsync(ctx, msg.getOriginator());
            }
            case "TENANT": {
                return Futures.immediateFuture((Object)ctx.getTenantId());
            }
            case "RELATED": {
                return EntitiesRelatedEntityIdAsyncLoader.findEntityAsync(ctx, msg.getOriginator(), this.config.getRelationsQuery());
            }
            case "ALARM_ORIGINATOR": {
                return EntitiesAlarmOriginatorIdAsyncLoader.findEntityIdAsync(ctx, msg.getOriginator());
            }
            case "ENTITY": {
                EntityType entityType = EntityType.valueOf((String)this.config.getEntityType());
                String entityName = TbNodeUtils.processPattern((String)this.config.getEntityNamePattern(), (TbMsg)msg);
                try {
                    EntityId targetEntity = EntitiesByNameAndTypeLoader.findEntityId(ctx, entityType, entityName);
                    return Futures.immediateFuture((Object)targetEntity);
                }
                catch (IllegalStateException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unexpected originator source " + this.config.getOriginatorSource()));
    }

    private void validateConfig(TbChangeOriginatorNodeConfiguration conf) {
        HashSet knownSources = Sets.newHashSet((Object[])new String[]{CUSTOMER_SOURCE, TENANT_SOURCE, RELATED_SOURCE, ALARM_ORIGINATOR_SOURCE, ENTITY_SOURCE});
        if (!knownSources.contains(conf.getOriginatorSource())) {
            log.error("Unsupported source [{}] for TbChangeOriginatorNode", (Object)conf.getOriginatorSource());
            throw new IllegalArgumentException("Unsupported source TbChangeOriginatorNode" + conf.getOriginatorSource());
        }
        if (conf.getOriginatorSource().equals(RELATED_SOURCE) && conf.getRelationsQuery() == null) {
            log.error("Related source for TbChangeOriginatorNode should have relations query. Actual [{}]", (Object)conf.getRelationsQuery());
            throw new IllegalArgumentException("Wrong config for RElated Source in TbChangeOriginatorNode" + conf.getOriginatorSource());
        }
        if (conf.getOriginatorSource().equals(ENTITY_SOURCE)) {
            if (conf.getEntityType() == null) {
                log.error("Entity type not specified for [{}]", (Object)ENTITY_SOURCE);
                throw new IllegalArgumentException("Wrong config for [{}] in TbChangeOriginatorNode!ENTITY");
            }
            if (StringUtils.isEmpty((String)conf.getEntityNamePattern())) {
                log.error("EntityNamePattern not specified for type [{}]", (Object)conf.getEntityType());
                throw new IllegalArgumentException("Wrong config for [{}] in TbChangeOriginatorNode!ENTITY");
            }
            EntitiesByNameAndTypeLoader.checkEntityType(EntityType.valueOf((String)conf.getEntityType()));
        }
    }
}

