/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.telemetry.AttributesDeleteNodeCallback;
import org.thingsboard.rule.engine.telemetry.TbMsgDeleteAttributesNodeConfiguration;
import org.thingsboard.rule.engine.telemetry.TelemetryNodeCallback;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="delete attributes", configClazz=TbMsgDeleteAttributesNodeConfiguration.class, nodeDescription="Delete attributes for Message Originator.", nodeDetails="Attempt to remove attributes by selected keys. If msg originator doesn't have an attribute with  a key selected in the configuration, it will be ignored. If delete operation is completed successfully,  rule node will send the \"Attributes Deleted\" event to the root chain of the message originator and  send the incoming message via <b>Success</b> chain, otherwise, <b>Failure</b> chain is used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeDeleteAttributesConfig", icon="remove_circle")
public class TbMsgDeleteAttributesNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgDeleteAttributesNode.class);
    private TbMsgDeleteAttributesNodeConfiguration config;
    private List<String> keys;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgDeleteAttributesNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgDeleteAttributesNodeConfiguration.class);
        this.keys = this.config.getKeys();
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        List<String> keysToDelete = this.keys.stream().map(keyPattern -> TbNodeUtils.processPattern((String)keyPattern, (TbMsg)msg)).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (keysToDelete.isEmpty()) {
            ctx.tellSuccess(msg);
        } else {
            String scope = this.getScope(msg.getMetaData().getValue("scope"));
            ctx.getTelemetryService().deleteAndNotify(ctx.getTenantId(), msg.getOriginator(), scope, keysToDelete, this.checkNotifyDevice(msg.getMetaData().getValue("notifyDevice"), scope), (FutureCallback)(this.config.isSendAttributesDeletedNotification() ? new AttributesDeleteNodeCallback(ctx, msg, scope, keysToDelete) : new TelemetryNodeCallback(ctx, msg)));
        }
    }

    private String getScope(String mdScopeValue) {
        if (StringUtils.isNotEmpty((String)mdScopeValue)) {
            return mdScopeValue;
        }
        return this.config.getScope();
    }

    private boolean checkNotifyDevice(String notifyDeviceMdValue, String scope) {
        return "SHARED_SCOPE".equals(scope) && (this.config.isNotifyDevice() || Boolean.parseBoolean(notifyDeviceMdValue));
    }
}

