/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.telemetry.AttributesUpdateNodeCallback;
import org.thingsboard.rule.engine.telemetry.TbMsgAttributesNodeConfiguration;
import org.thingsboard.rule.engine.telemetry.TelemetryNodeCallback;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;

@RuleNode(type=ComponentType.ACTION, name="save attributes", configClazz=TbMsgAttributesNodeConfiguration.class, nodeDescription="Saves attributes data", nodeDetails="Saves entity attributes based on configurable scope parameter. Expects messages with 'POST_ATTRIBUTES_REQUEST' message type. If upsert(update/insert) operation is completed successfully rule node will send the incoming message via <b>Success</b> chain, otherwise, <b>Failure</b> chain is used. Additionally if checkbox <b>Send attributes updated notification</b> is set to true, rule node will put the \"Attributes Updated\" event for <b>SHARED_SCOPE</b> and <b>SERVER_SCOPE</b> attributes updates to the corresponding rule engine queue.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeAttributesConfig", icon="file_upload")
public class TbMsgAttributesNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgAttributesNode.class);
    private TbMsgAttributesNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgAttributesNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgAttributesNodeConfiguration.class);
        if (this.config.getNotifyDevice() == null) {
            this.config.setNotifyDevice(true);
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (!msg.getType().equals(SessionMsgType.POST_ATTRIBUTES_REQUEST.name())) {
            ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Unsupported msg type: " + msg.getType()));
            return;
        }
        String src = msg.getData();
        ArrayList<AttributeKvEntry> attributes = new ArrayList<AttributeKvEntry>(JsonConverter.convertToAttributes((JsonElement)JsonParser.parseString((String)src)));
        if (attributes.isEmpty()) {
            ctx.tellSuccess(msg);
            return;
        }
        String scope = this.getScope(msg.getMetaData().getValue("scope"));
        boolean sendAttributesUpdateNotification = this.checkSendNotification(scope);
        ctx.getTelemetryService().saveAndNotify(ctx.getTenantId(), msg.getOriginator(), scope, attributes, this.checkNotifyDevice(msg.getMetaData().getValue("notifyDevice")), (FutureCallback)(sendAttributesUpdateNotification ? new AttributesUpdateNodeCallback(ctx, msg, scope, attributes) : new TelemetryNodeCallback(ctx, msg)));
    }

    private boolean checkSendNotification(String scope) {
        return this.config.isSendAttributesUpdatedNotification() && !"CLIENT_SCOPE".equals(scope);
    }

    private boolean checkNotifyDevice(String notifyDeviceMdValue) {
        return this.config.getNotifyDevice() != false || StringUtils.isEmpty((String)notifyDeviceMdValue) || Boolean.parseBoolean(notifyDeviceMdValue);
    }

    private String getScope(String mdScopeValue) {
        if (StringUtils.isNotEmpty((String)mdScopeValue)) {
            return mdScopeValue;
        }
        return this.config.getScope();
    }
}

