/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.notification;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.notification.TbNotificationNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleEngineOriginatedNotificationInfo;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.EXTERNAL, name="send notification", configClazz=TbNotificationNodeConfiguration.class, nodeDescription="Sends notification to targets using the template", nodeDetails="Will send notification to the specified targets using the template", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbExternalNodeNotificationConfig", icon="notifications")
public class TbNotificationNode
implements TbNode {
    private TbNotificationNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbNotificationNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbNotificationNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        RuleEngineOriginatedNotificationInfo notificationInfo = RuleEngineOriginatedNotificationInfo.builder().msgOriginator(msg.getOriginator()).msgMetadata(msg.getMetaData().getData()).msgData(JacksonUtil.toFlatMap((JsonNode)JacksonUtil.toJsonNode((String)msg.getData()))).msgType(msg.getType()).build();
        NotificationRequest notificationRequest = NotificationRequest.builder().tenantId(ctx.getTenantId()).targets(this.config.getTargets()).templateId(this.config.getTemplateId()).info((NotificationInfo)notificationInfo).additionalConfig(new NotificationRequestConfig()).originatorEntityId((EntityId)ctx.getSelf().getRuleChainId()).build();
        DonAsynchron.withCallback((ListenableFuture)ctx.getNotificationExecutor().executeAsync(() -> ctx.getNotificationCenter().processNotificationRequest(ctx.getTenantId(), notificationRequest, stats -> {
            TbMsgMetaData metaData = msg.getMetaData().copy();
            metaData.putValue("notificationRequestResult", JacksonUtil.toString((Object)stats));
            ctx.tellSuccess(TbMsg.transformMsg((TbMsg)msg, (TbMsgMetaData)metaData));
        })), r -> {}, e -> ctx.tellFailure(msg, e));
    }
}

