/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mqtt.azure;

import io.netty.handler.codec.mqtt.MqttVersion;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.AzureIotHubUtil;
import org.thingsboard.mqtt.MqttClientConfig;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.credentials.CertPemCredentials;
import org.thingsboard.rule.engine.credentials.ClientCredentials;
import org.thingsboard.rule.engine.credentials.CredentialsType;
import org.thingsboard.rule.engine.mqtt.TbMqttNode;
import org.thingsboard.rule.engine.mqtt.TbMqttNodeConfiguration;
import org.thingsboard.rule.engine.mqtt.azure.AzureIotHubSasCredentials;
import org.thingsboard.rule.engine.mqtt.azure.TbAzureIotHubNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentClusteringMode;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.EXTERNAL, name="azure iot hub", configClazz=TbAzureIotHubNodeConfiguration.class, clusteringMode=ComponentClusteringMode.SINGLETON, nodeDescription="Publish messages to the Azure IoT Hub", nodeDetails="Will publish message payload to the Azure IoT Hub with QoS <b>AT_LEAST_ONCE</b>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbExternalNodeAzureIotHubConfig")
public class TbAzureIotHubNode
extends TbMqttNode {
    private static final Logger log = LoggerFactory.getLogger(TbAzureIotHubNode.class);

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        try {
            CertPemCredentials pemCredentials;
            this.mqttNodeConfiguration = (TbMqttNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMqttNodeConfiguration.class);
            this.mqttNodeConfiguration.setPort(8883);
            this.mqttNodeConfiguration.setCleanSession(true);
            ClientCredentials credentials = this.mqttNodeConfiguration.getCredentials();
            if (CredentialsType.CERT_PEM == credentials.getType() && ((pemCredentials = (CertPemCredentials)credentials).getCaCert() == null || pemCredentials.getCaCert().isEmpty())) {
                pemCredentials.setCaCert(AzureIotHubUtil.getDefaultCaCert());
            }
            this.mqttClient = this.initClient(ctx);
        }
        catch (Exception e) {
            throw new TbNodeException(e);
        }
    }

    @Override
    protected void prepareMqttClientConfig(MqttClientConfig config) throws SSLException {
        config.setProtocolVersion(MqttVersion.MQTT_3_1_1);
        config.setUsername(AzureIotHubUtil.buildUsername((String)this.mqttNodeConfiguration.getHost(), (String)config.getClientId()));
        ClientCredentials credentials = this.mqttNodeConfiguration.getCredentials();
        if (CredentialsType.SAS == credentials.getType()) {
            config.setPassword(AzureIotHubUtil.buildSasToken((String)this.mqttNodeConfiguration.getHost(), (String)((AzureIotHubSasCredentials)credentials).getSasKey()));
        }
    }
}

