/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbGetTelemetryNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="originator telemetry", configClazz=TbGetTelemetryNodeConfiguration.class, nodeDescription="Add Message Originator Telemetry for selected time range into Message Metadata\n", nodeDetails="The node allows you to select fetch mode: <b>FIRST/LAST/ALL</b> to fetch telemetry of certain time range that are added into Message metadata without any prefix. If selected fetch mode <b>ALL</b> Telemetry will be added like array into Message Metadata where <b>key</b> is Timestamp and <b>value</b> is value of Telemetry.</br>If selected fetch mode <b>FIRST</b> or <b>LAST</b> Telemetry will be added like string without Timestamp.</br>Also, the rule node allows you to select telemetry sampling order: <b>ASC</b> or <b>DESC</b>. </br>Aggregation feature allows you to fetch aggregated telemetry as a single value by <b>AVG, COUNT, SUM, MIN, MAX, NONE</b>. </br><b>Note</b>: The maximum size of the fetched array is 1000 records.\n ", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeGetTelemetryFromDatabase")
public class TbGetTelemetryNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbGetTelemetryNode.class);
    private static final String DESC_ORDER = "DESC";
    private static final String ASC_ORDER = "ASC";
    private TbGetTelemetryNodeConfiguration config;
    private List<String> tsKeyNames;
    private int limit;
    private String fetchMode;
    private String orderByFetchAll;
    private Aggregation aggregation;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGetTelemetryNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetTelemetryNodeConfiguration.class);
        this.tsKeyNames = this.config.getLatestTsKeyNames();
        this.limit = this.config.getFetchMode().equals("ALL") ? this.validateLimit(this.config.getLimit()) : 1;
        this.fetchMode = this.config.getFetchMode();
        this.orderByFetchAll = this.config.getOrderBy();
        if (StringUtils.isEmpty((String)this.orderByFetchAll)) {
            this.orderByFetchAll = ASC_ORDER;
        }
        this.aggregation = this.parseAggregationConfig(this.config.getAggregation());
    }

    Aggregation parseAggregationConfig(String aggName) {
        if (StringUtils.isEmpty((String)aggName) || !this.fetchMode.equals("ALL")) {
            return Aggregation.NONE;
        }
        return Aggregation.valueOf((String)aggName);
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        if (this.tsKeyNames.isEmpty()) {
            ctx.tellFailure(msg, (Throwable)new IllegalStateException("Telemetry is not selected!"));
        } else {
            try {
                Interval interval = this.getInterval(msg);
                List keys = TbNodeUtils.processPatterns(this.tsKeyNames, (TbMsg)msg);
                ListenableFuture list = ctx.getTimeseriesService().findAll(ctx.getTenantId(), msg.getOriginator(), this.buildQueries(interval, keys));
                DonAsynchron.withCallback((ListenableFuture)list, data -> {
                    this.process((List<TsKvEntry>)data, msg, keys);
                    ctx.tellSuccess(ctx.transformMsg(msg, msg.getType(), msg.getOriginator(), msg.getMetaData(), msg.getData()));
                }, error -> ctx.tellFailure(msg, error), (Executor)ctx.getDbCallbackExecutor());
            }
            catch (Exception e) {
                ctx.tellFailure(msg, (Throwable)e);
            }
        }
    }

    private List<ReadTsKvQuery> buildQueries(Interval interval, List<String> keys) {
        long aggIntervalStep = Aggregation.NONE.equals((Object)this.aggregation) ? 1L : interval.getEndTs() - interval.getStartTs();
        return keys.stream().map(key -> new BaseReadTsKvQuery(key, interval.getStartTs().longValue(), interval.getEndTs().longValue(), aggIntervalStep, this.limit, this.aggregation, this.getOrderBy())).collect(Collectors.toList());
    }

    private String getOrderBy() {
        switch (this.fetchMode) {
            case "ALL": {
                return this.orderByFetchAll;
            }
            case "FIRST": {
                return ASC_ORDER;
            }
        }
        return DESC_ORDER;
    }

    private void process(List<TsKvEntry> entries, TbMsg msg, List<String> keys) {
        ObjectNode resultNode = JacksonUtil.newObjectNode((ObjectMapper)JacksonUtil.ALLOW_UNQUOTED_FIELD_NAMES_MAPPER);
        if ("ALL".equals(this.fetchMode)) {
            entries.forEach(entry -> this.processArray(resultNode, (TsKvEntry)entry));
        } else {
            entries.forEach(entry -> this.processSingle(resultNode, (TsKvEntry)entry));
        }
        for (String key : keys) {
            if (!resultNode.has(key)) continue;
            msg.getMetaData().putValue(key, resultNode.get(key).toString());
        }
    }

    private void processSingle(ObjectNode node, TsKvEntry entry) {
        node.put(entry.getKey(), entry.getValueAsString());
    }

    private void processArray(ObjectNode node, TsKvEntry entry) {
        if (node.has(entry.getKey())) {
            ArrayNode arrayNode = (ArrayNode)node.get(entry.getKey());
            arrayNode.add((JsonNode)this.buildNode(entry));
        } else {
            ArrayNode arrayNode = JacksonUtil.ALLOW_UNQUOTED_FIELD_NAMES_MAPPER.createArrayNode();
            arrayNode.add((JsonNode)this.buildNode(entry));
            node.set(entry.getKey(), (JsonNode)arrayNode);
        }
    }

    private ObjectNode buildNode(TsKvEntry entry) {
        ObjectNode obj = JacksonUtil.newObjectNode((ObjectMapper)JacksonUtil.ALLOW_UNQUOTED_FIELD_NAMES_MAPPER);
        obj.put("ts", entry.getTs());
        JacksonUtil.addKvEntry((ObjectNode)obj, (KvEntry)entry, (String)"value", (ObjectMapper)JacksonUtil.ALLOW_UNQUOTED_FIELD_NAMES_MAPPER);
        return obj;
    }

    private Interval getInterval(TbMsg msg) {
        if (this.config.isUseMetadataIntervalPatterns()) {
            return this.getIntervalFromPatterns(msg);
        }
        Interval interval = new Interval();
        long ts = System.currentTimeMillis();
        interval.setStartTs(ts - TimeUnit.valueOf(this.config.getStartIntervalTimeUnit()).toMillis(this.config.getStartInterval()));
        interval.setEndTs(ts - TimeUnit.valueOf(this.config.getEndIntervalTimeUnit()).toMillis(this.config.getEndInterval()));
        return interval;
    }

    private Interval getIntervalFromPatterns(TbMsg msg) {
        Interval interval = new Interval();
        interval.setStartTs(this.checkPattern(msg, this.config.getStartIntervalPattern()));
        interval.setEndTs(this.checkPattern(msg, this.config.getEndIntervalPattern()));
        return interval;
    }

    private long checkPattern(TbMsg msg, String pattern) {
        String value = this.getValuePattern(msg, pattern);
        if (value == null) {
            throw new IllegalArgumentException("Message value: '" + this.replaceRegex(pattern) + "' is undefined");
        }
        boolean parsable = NumberUtils.isParsable((String)value);
        if (!parsable) {
            throw new IllegalArgumentException("Message value: '" + this.replaceRegex(pattern) + "' has invalid format");
        }
        return Long.parseLong(value);
    }

    private String getValuePattern(TbMsg msg, String pattern) {
        String value = TbNodeUtils.processPattern((String)pattern, (TbMsg)msg);
        return value.equals(pattern) ? null : value;
    }

    private String replaceRegex(String pattern) {
        return pattern.replaceAll("[$\\[{}\\]]", "");
    }

    private int validateLimit(int limit) {
        if (limit != 0) {
            return limit;
        }
        return 1000;
    }

    private static class Interval {
        private Long startTs;
        private Long endTs;

        public Long getStartTs() {
            return this.startTs;
        }

        public Long getEndTs() {
            return this.endTs;
        }

        public void setStartTs(Long startTs) {
            this.startTs = startTs;
        }

        public void setEndTs(Long endTs) {
            this.endTs = endTs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$startTs = this.getStartTs();
            Long other$startTs = other.getStartTs();
            if (this$startTs == null ? other$startTs != null : !((Object)this$startTs).equals(other$startTs)) {
                return false;
            }
            Long this$endTs = this.getEndTs();
            Long other$endTs = other.getEndTs();
            return !(this$endTs == null ? other$endTs != null : !((Object)this$endTs).equals(other$endTs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Interval;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $startTs = this.getStartTs();
            result = result * 59 + ($startTs == null ? 43 : ((Object)$startTs).hashCode());
            Long $endTs = this.getEndTs();
            result = result * 59 + ($endTs == null ? 43 : ((Object)$endTs).hashCode());
            return result;
        }

        public String toString() {
            return "TbGetTelemetryNode.Interval(startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ")";
        }
    }
}

