/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbEntityGetAttrNode;
import org.thingsboard.rule.engine.metadata.TbGetRelatedAttrNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.ENRICHMENT, name="related attributes", configClazz=TbGetRelatedAttrNodeConfiguration.class, nodeDescription="Add Originators Related Entity Attributes or Latest Telemetry into Message Metadata", nodeDetails="Related Entity found using configured relation direction and Relation Type. If multiple Related Entities are found, only first Entity is used for attributes enrichment, other entities are discarded. If Attributes enrichment configured, server scope attributes are added into Message metadata. If Latest Telemetry enrichment configured, latest telemetry added into metadata. To access those attributes in other nodes this template can be used <code>metadata.temperature</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeRelatedAttributesConfig")
public class TbGetRelatedAttributeNode
extends TbEntityGetAttrNode<EntityId> {
    private TbGetRelatedAttrNodeConfiguration config;

    @Override
    public void init(TbContext context, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGetRelatedAttrNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetRelatedAttrNodeConfiguration.class);
        this.setConfig(this.config);
    }

    @Override
    protected ListenableFuture<EntityId> findEntityAsync(TbContext ctx, EntityId originator) {
        return EntitiesRelatedEntityIdAsyncLoader.findEntityAsync(ctx, originator, this.config.getRelationsQuery());
    }
}

