/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbGetOriginatorFieldsConfiguration;
import org.thingsboard.rule.engine.util.EntitiesFieldsAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="originator fields", configClazz=TbGetOriginatorFieldsConfiguration.class, nodeDescription="Add Message Originator fields values into Message Metadata", nodeDetails="Will fetch fields values specified in mapping. If specified field is not part of originator fields it will be ignored.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeOriginatorFieldsConfig")
public class TbGetOriginatorFieldsNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbGetOriginatorFieldsNode.class);
    private TbGetOriginatorFieldsConfiguration config;
    private boolean ignoreNullStrings;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGetOriginatorFieldsConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetOriginatorFieldsConfiguration.class);
        this.ignoreNullStrings = this.config.isIgnoreNullStrings();
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            DonAsynchron.withCallback(this.putEntityFields(ctx, msg.getOriginator(), msg), i -> ctx.tellSuccess(msg), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
        }
        catch (Throwable th) {
            ctx.tellFailure(msg, th);
        }
    }

    private ListenableFuture<Void> putEntityFields(TbContext ctx, EntityId entityId, TbMsg msg) {
        if (this.config.getFieldsMapping().isEmpty()) {
            return Futures.immediateFuture(null);
        }
        return Futures.transform(EntitiesFieldsAsyncLoader.findAsync(ctx, entityId), data -> {
            this.config.getFieldsMapping().forEach((field, metaKey) -> {
                String val = data.getFieldValue(field, this.ignoreNullStrings);
                if (val != null) {
                    msg.getMetaData().putValue(metaKey, val);
                }
            });
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }
}

