/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetAttributesNode;
import org.thingsboard.rule.engine.metadata.TbGetDeviceAttrNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesRelatedDeviceIdAsyncLoader;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="related device attributes", configClazz=TbGetDeviceAttrNodeConfiguration.class, nodeDescription="Add Originators Related Device Attributes and Latest Telemetry value into Message Data or Metadata", nodeDetails="If Attributes enrichment configured, <b>CLIENT/SHARED/SERVER</b> attributes are added into Message data/metadata with specific prefix: <i>cs/shared/ss</i>. Latest telemetry value added into Message data/metadata without prefix. To access those attributes in other nodes this template can be used <code>metadata.cs_temperature</code> or <code>metadata.shared_limit</code> ", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeDeviceAttributesConfig")
public class TbGetDeviceAttrNode
extends TbAbstractGetAttributesNode<TbGetDeviceAttrNodeConfiguration, DeviceId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetDeviceAttrNode.class);

    @Override
    protected TbGetDeviceAttrNodeConfiguration loadGetAttributesNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbGetDeviceAttrNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetDeviceAttrNodeConfiguration.class);
    }

    @Override
    protected ListenableFuture<DeviceId> findEntityIdAsync(TbContext ctx, TbMsg msg) {
        return EntitiesRelatedDeviceIdAsyncLoader.findDeviceAsync(ctx, msg.getOriginator(), ((TbGetDeviceAttrNodeConfiguration)this.config).getDeviceRelationsQuery());
    }
}

