/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNode;
import org.thingsboard.rule.engine.metadata.TbGetCustomerDetailsNodeConfiguration;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="customer details", configClazz=TbGetCustomerDetailsNodeConfiguration.class, nodeDescription="Enrich the message body or metadata with the corresponding customer details: title, address, email, phone, etc.", nodeDetails="If checkbox: <b>Add selected details to the message metadata</b> is selected, existing fields will be added to the message metadata instead of message data.<br><br><b>Note:</b> only Device, Asset, and Entity View type are allowed.<br><br>If the originator of the message is not assigned to Customer, or originator type is not supported - Message will be forwarded to <b>Failure</b> chain, otherwise, <b>Success</b> chain will be used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeEntityDetailsConfig")
public class TbGetCustomerDetailsNode
extends TbAbstractGetEntityDetailsNode<TbGetCustomerDetailsNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbGetCustomerDetailsNode.class);
    private static final String CUSTOMER_PREFIX = "customer_";

    @Override
    protected TbGetCustomerDetailsNodeConfiguration loadGetEntityDetailsNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbGetCustomerDetailsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetCustomerDetailsNodeConfiguration.class);
    }

    @Override
    protected ListenableFuture<TbMsg> getDetails(TbContext ctx, TbMsg msg) {
        return this.getTbMsgListenableFuture(ctx, msg, this.getDataAsJson(msg), CUSTOMER_PREFIX);
    }

    @Override
    protected ListenableFuture<? extends ContactBased> getContactBasedListenableFuture(TbContext ctx, TbMsg msg) {
        return this.getCustomer(ctx, msg);
    }

    private ListenableFuture<Customer> getCustomer(TbContext ctx, TbMsg msg) {
        ListenableFuture entityFuture;
        switch (msg.getOriginator().getEntityType()) {
            case DEVICE: {
                entityFuture = Futures.immediateFuture((Object)ctx.getDeviceService().findDeviceById(ctx.getTenantId(), (DeviceId)msg.getOriginator()));
                break;
            }
            case ASSET: {
                entityFuture = ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), (AssetId)msg.getOriginator());
                break;
            }
            case ENTITY_VIEW: {
                entityFuture = ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), (EntityViewId)msg.getOriginator());
                break;
            }
            case USER: {
                entityFuture = ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), (UserId)msg.getOriginator());
                break;
            }
            case EDGE: {
                entityFuture = ctx.getEdgeService().findEdgeByIdAsync(ctx.getTenantId(), (EdgeId)msg.getOriginator());
                break;
            }
            default: {
                throw new RuntimeException(msg.getOriginator().getEntityType().getNormalName() + " entities not supported");
            }
        }
        return Futures.transformAsync((ListenableFuture)entityFuture, entity -> {
            if (entity != null) {
                if (!entity.getCustomerId().isNullUid()) {
                    return ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), entity.getCustomerId());
                }
                throw new RuntimeException(msg.getOriginator().getEntityType().getNormalName() + (String)(entity instanceof HasName ? " with name '" + ((HasName)entity).getName() + "'" : "") + " is not assigned to Customer");
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
    }
}

