/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetAttributesNode;
import org.thingsboard.rule.engine.metadata.TbGetAttributesNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="originator attributes", configClazz=TbGetAttributesNodeConfiguration.class, nodeDescription="Enrich the message body or metadata with the originator attributes and/or timeseries data", nodeDetails="If Attributes enrichment configured, <b>CLIENT/SHARED/SERVER</b> attributes are added into Message data/metadata with specific prefix: <i>cs/shared/ss</i>. Latest telemetry value added into Message data/metadata without prefix. To access those attributes in other nodes this template can be used <code>metadata.cs_temperature</code> or <code>metadata.shared_limit</code> ", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeOriginatorAttributesConfig")
public class TbGetAttributesNode
extends TbAbstractGetAttributesNode<TbGetAttributesNodeConfiguration, EntityId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetAttributesNode.class);

    @Override
    protected TbGetAttributesNodeConfiguration loadGetAttributesNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbGetAttributesNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetAttributesNodeConfiguration.class);
    }

    @Override
    protected ListenableFuture<EntityId> findEntityIdAsync(TbContext ctx, TbMsg msg) {
        return Futures.immediateFuture((Object)msg.getOriginator());
    }
}

