/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbFetchDeviceCredentialsNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ENRICHMENT, name="fetch device credentials", configClazz=TbFetchDeviceCredentialsNodeConfiguration.class, nodeDescription="Enrich the message body or metadata with the device credentials", nodeDetails="Adds <b>credentialsType</b> and <b>credentials</b> properties to the message metadata if the configuration parameter <b>fetchToMetadata</b> is set to <code>true</code>, otherwise, adds properties to the message data. If originator type is not <b>DEVICE</b> or rule node failed to get device credentials - send Message via <code>Failure</code> chain, otherwise <code>Success</code> chain is used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeFetchDeviceCredentialsConfig")
public class TbFetchDeviceCredentialsNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbFetchDeviceCredentialsNode.class);
    private static final String CREDENTIALS = "credentials";
    private static final String CREDENTIALS_TYPE = "credentialsType";
    TbFetchDeviceCredentialsNodeConfiguration config;
    boolean fetchToMetadata;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbFetchDeviceCredentialsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbFetchDeviceCredentialsNodeConfiguration.class);
        this.fetchToMetadata = this.config.isFetchToMetadata();
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsg transformedMsg;
        EntityId originator = msg.getOriginator();
        if (!EntityType.DEVICE.equals((Object)originator.getEntityType())) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Unsupported originator type: " + originator.getEntityType() + "!"));
            return;
        }
        DeviceId deviceId = new DeviceId(msg.getOriginator().getId());
        DeviceCredentials deviceCredentials = ctx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(ctx.getTenantId(), deviceId);
        if (deviceCredentials == null) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Failed to get Device Credentials for device: " + deviceId + "!"));
            return;
        }
        DeviceCredentialsType credentialsType = deviceCredentials.getCredentialsType();
        JsonNode credentialsInfo = ctx.getDeviceCredentialsService().toCredentialsInfo(deviceCredentials);
        if (this.fetchToMetadata) {
            TbMsgMetaData metaData = msg.getMetaData();
            metaData.putValue(CREDENTIALS_TYPE, credentialsType.name());
            if (credentialsType.equals((Object)DeviceCredentialsType.ACCESS_TOKEN) || credentialsType.equals((Object)DeviceCredentialsType.X509_CERTIFICATE)) {
                metaData.putValue(CREDENTIALS, credentialsInfo.asText());
            } else {
                metaData.putValue(CREDENTIALS, JacksonUtil.toString((Object)credentialsInfo));
            }
            transformedMsg = TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)originator, (TbMsgMetaData)metaData, (String)msg.getData());
        } else {
            ObjectNode data = (ObjectNode)JacksonUtil.toJsonNode((String)msg.getData());
            data.put(CREDENTIALS_TYPE, credentialsType.name());
            data.set(CREDENTIALS, credentialsInfo);
            transformedMsg = TbMsg.transformMsg((TbMsg)msg, (String)msg.getType(), (EntityId)originator, (TbMsgMetaData)msg.getMetaData(), (String)JacksonUtil.toString((Object)data));
        }
        ctx.tellSuccess(transformedMsg);
    }
}

