/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbGetAttributesNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractGetAttributesNode<C extends TbGetAttributesNodeConfiguration, T extends EntityId>
implements TbNode {
    private static final String VALUE = "value";
    private static final String TS = "ts";
    protected C config;
    private boolean fetchToData;
    private boolean isTellFailureIfAbsent;
    private boolean getLatestValueWithTs;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadGetAttributesNodeConfig(configuration);
        this.fetchToData = ((TbGetAttributesNodeConfiguration)this.config).isFetchToData();
        this.getLatestValueWithTs = ((TbGetAttributesNodeConfiguration)this.config).isGetLatestValueWithTs();
        this.isTellFailureIfAbsent = BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbGetAttributesNodeConfiguration)this.config).isTellFailureIfAbsent(), (boolean)true);
    }

    protected abstract C loadGetAttributesNodeConfig(TbNodeConfiguration var1) throws TbNodeException;

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        try {
            DonAsynchron.withCallback(this.findEntityIdAsync(ctx, msg), entityId -> this.safePutAttributes(ctx, msg, entityId), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
        }
        catch (Throwable th) {
            ctx.tellFailure(msg, th);
        }
    }

    protected abstract ListenableFuture<T> findEntityIdAsync(TbContext var1, TbMsg var2);

    private void safePutAttributes(TbContext ctx, TbMsg msg, T entityId) {
        JsonNode msgDataNode;
        if (entityId == null || entityId.isNullUid()) {
            ctx.tellNext(msg, TbRelationTypes.FAILURE);
            return;
        }
        if (this.fetchToData) {
            msgDataNode = JacksonUtil.toJsonNode((String)msg.getData());
            if (!msgDataNode.isObject()) {
                ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Msg body is not an object!"));
                return;
            }
        } else {
            msgDataNode = null;
        }
        ConcurrentHashMap<String, List<String>> failuresMap = new ConcurrentHashMap<String, List<String>>();
        ListenableFuture allFutures = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.getLatestTelemetry(ctx, (EntityId)entityId, TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getLatestTsKeyNames(), (TbMsg)msg), failuresMap), this.getAttrAsync(ctx, (EntityId)entityId, "CLIENT_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getClientAttributeNames(), (TbMsg)msg), failuresMap), this.getAttrAsync(ctx, (EntityId)entityId, "SHARED_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getSharedAttributeNames(), (TbMsg)msg), failuresMap), this.getAttrAsync(ctx, (EntityId)entityId, "SERVER_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getServerAttributeNames(), (TbMsg)msg), failuresMap)});
        DonAsynchron.withCallback((ListenableFuture)allFutures, futuresList -> {
            TbMsg outMsg;
            TbMsgMetaData msgMetaData = msg.getMetaData().copy();
            futuresList.stream().filter(Objects::nonNull).forEach(kvEntriesMap -> kvEntriesMap.forEach((keyScope, kvEntryList) -> {
                String prefix = this.getPrefix((String)keyScope);
                kvEntryList.forEach(kvEntry -> {
                    String key = prefix + kvEntry.getKey();
                    if (this.fetchToData) {
                        JacksonUtil.addKvEntry((ObjectNode)((ObjectNode)msgDataNode), (KvEntry)kvEntry, (String)key);
                    } else {
                        msgMetaData.putValue(key, kvEntry.getValueAsString());
                    }
                });
            }));
            TbMsg tbMsg = outMsg = this.fetchToData ? TbMsg.transformMsgData((TbMsg)msg, (String)JacksonUtil.toString((Object)msgDataNode)) : TbMsg.transformMsg((TbMsg)msg, (TbMsgMetaData)msgMetaData);
            if (failuresMap.isEmpty()) {
                ctx.tellSuccess(outMsg);
            } else {
                ctx.tellFailure(outMsg, (Throwable)this.reportFailures(failuresMap));
            }
        }, t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Map<String, List<AttributeKvEntry>>> getAttrAsync(TbContext ctx, EntityId entityId, String scope, List<String> keys, ConcurrentHashMap<String, List<String>> failuresMap) {
        if (CollectionUtils.isEmpty(keys)) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture attributeKvEntryListFuture = ctx.getAttributesService().find(ctx.getTenantId(), entityId, scope, keys);
        return Futures.transform((ListenableFuture)attributeKvEntryListFuture, attributeKvEntryList -> {
            if (this.isTellFailureIfAbsent && attributeKvEntryList.size() != keys.size()) {
                this.getNotExistingKeys((List<AttributeKvEntry>)attributeKvEntryList, keys).forEach(key -> this.computeFailuresMap(scope, failuresMap, (String)key));
            }
            HashMap<String, List> mapAttributeKvEntry = new HashMap<String, List>();
            mapAttributeKvEntry.put(scope, (List)attributeKvEntryList);
            return mapAttributeKvEntry;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Map<String, List<TsKvEntry>>> getLatestTelemetry(TbContext ctx, EntityId entityId, List<String> keys, ConcurrentHashMap<String, List<String>> failuresMap) {
        if (CollectionUtils.isEmpty(keys)) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture latestTelemetryFutures = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, keys);
        return Futures.transform((ListenableFuture)latestTelemetryFutures, tsKvEntries -> {
            ArrayList listTsKvEntry = new ArrayList();
            tsKvEntries.forEach(tsKvEntry -> {
                if (tsKvEntry.getValue() == null) {
                    if (this.isTellFailureIfAbsent) {
                        this.computeFailuresMap("LATEST_TS", failuresMap, tsKvEntry.getKey());
                    }
                } else if (this.getLatestValueWithTs) {
                    listTsKvEntry.add(this.getValueWithTs((TsKvEntry)tsKvEntry));
                } else {
                    listTsKvEntry.add(new BasicTsKvEntry(tsKvEntry.getTs(), (KvEntry)tsKvEntry));
                }
            });
            HashMap mapTsKvEntry = new HashMap();
            mapTsKvEntry.put("LATEST_TS", listTsKvEntry);
            return mapTsKvEntry;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private TsKvEntry getValueWithTs(TsKvEntry tsKvEntry) {
        ObjectMapper mapper = this.fetchToData ? JacksonUtil.OBJECT_MAPPER : JacksonUtil.ALLOW_UNQUOTED_FIELD_NAMES_MAPPER;
        ObjectNode value = JacksonUtil.newObjectNode((ObjectMapper)mapper);
        value.put(TS, tsKvEntry.getTs());
        JacksonUtil.addKvEntry((ObjectNode)value, (KvEntry)tsKvEntry, (String)VALUE, (ObjectMapper)mapper);
        return new BasicTsKvEntry(tsKvEntry.getTs(), (KvEntry)new JsonDataEntry(tsKvEntry.getKey(), value.toString()));
    }

    private String getPrefix(String scope) {
        String prefix = "";
        switch (scope) {
            case "CLIENT_SCOPE": {
                prefix = "cs_";
                break;
            }
            case "SHARED_SCOPE": {
                prefix = "shared_";
                break;
            }
            case "SERVER_SCOPE": {
                prefix = "ss_";
            }
        }
        return prefix;
    }

    private List<String> getNotExistingKeys(List<AttributeKvEntry> existingAttributesKvEntry, List<String> allKeys) {
        List existingKeys = existingAttributesKvEntry.stream().map(KvEntry::getKey).collect(Collectors.toList());
        return allKeys.stream().filter(key -> !existingKeys.contains(key)).collect(Collectors.toList());
    }

    private void computeFailuresMap(String scope, ConcurrentHashMap<String, List<String>> failuresMap, String key) {
        List failures = failuresMap.computeIfAbsent(scope, k -> new ArrayList());
        failures.add(key);
    }

    private RuntimeException reportFailures(ConcurrentHashMap<String, List<String>> failuresMap) {
        StringBuilder errorMessage = new StringBuilder("The following attribute/telemetry keys is not present in the DB: ").append("\n");
        if (failuresMap.containsKey("CLIENT_SCOPE")) {
            errorMessage.append("\t").append("[CLIENT_SCOPE]:").append(failuresMap.get("CLIENT_SCOPE").toString()).append("\n");
        }
        if (failuresMap.containsKey("SERVER_SCOPE")) {
            errorMessage.append("\t").append("[SERVER_SCOPE]:").append(failuresMap.get("SERVER_SCOPE").toString()).append("\n");
        }
        if (failuresMap.containsKey("SHARED_SCOPE")) {
            errorMessage.append("\t").append("[SHARED_SCOPE]:").append(failuresMap.get("SHARED_SCOPE").toString()).append("\n");
        }
        if (failuresMap.containsKey("LATEST_TS")) {
            errorMessage.append("\t").append("[LATEST_TS]:").append(failuresMap.get("LATEST_TS").toString()).append("\n");
        }
        failuresMap.clear();
        return new RuntimeException(errorMessage.toString());
    }
}

