/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.math;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import org.thingsboard.rule.engine.math.TbMathArgument;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public class TbMathArgumentValue {
    private final double value;

    private TbMathArgumentValue(double value) {
        this.value = value;
    }

    public static TbMathArgumentValue constant(TbMathArgument arg) {
        return TbMathArgumentValue.fromString(arg.getKey());
    }

    private static TbMathArgumentValue defaultOrThrow(Double defaultValue, String error) {
        if (defaultValue != null) {
            return new TbMathArgumentValue(defaultValue);
        }
        throw new RuntimeException(error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TbMathArgumentValue fromMessageBody(TbMathArgument arg, Optional<ObjectNode> jsonNodeOpt) {
        double value;
        String key = arg.getKey();
        Double defaultValue = arg.getDefaultValue();
        if (jsonNodeOpt.isEmpty()) {
            return TbMathArgumentValue.defaultOrThrow(defaultValue, "Message body is empty!");
        }
        ObjectNode json = jsonNodeOpt.get();
        if (!json.has(key)) {
            return TbMathArgumentValue.defaultOrThrow(defaultValue, "Message body has no '" + key + "'!");
        }
        JsonNode valueNode = json.get(key);
        if (valueNode.isNull()) {
            return TbMathArgumentValue.defaultOrThrow(defaultValue, "Message body has null '" + key + "'!");
        }
        if (valueNode.isNumber()) {
            value = valueNode.doubleValue();
            return new TbMathArgumentValue(value);
        }
        if (!valueNode.isTextual()) throw new RuntimeException("Can't convert value '" + valueNode.toString() + "' to double!");
        String valueNodeText = valueNode.asText();
        if (!StringUtils.isNotBlank((String)valueNodeText)) return TbMathArgumentValue.defaultOrThrow(defaultValue, "Message value is empty for '" + key + "'!");
        try {
            value = Double.parseDouble(valueNode.asText());
            return new TbMathArgumentValue(value);
        }
        catch (NumberFormatException ne) {
            throw new RuntimeException("Can't convert value '" + valueNode.asText() + "' to double!");
        }
    }

    public static TbMathArgumentValue fromMessageMetadata(TbMathArgument arg, TbMsgMetaData metaData) {
        String key = arg.getKey();
        Double defaultValue = arg.getDefaultValue();
        if (metaData == null) {
            return TbMathArgumentValue.defaultOrThrow(defaultValue, "Message metadata is empty!");
        }
        String value = metaData.getValue(key);
        if (StringUtils.isEmpty((String)value)) {
            return TbMathArgumentValue.defaultOrThrow(defaultValue, "Message metadata has no '" + key + "'!");
        }
        return TbMathArgumentValue.fromString(value);
    }

    public static TbMathArgumentValue fromLong(long value) {
        return new TbMathArgumentValue(value);
    }

    public static TbMathArgumentValue fromDouble(double value) {
        return new TbMathArgumentValue(value);
    }

    public static TbMathArgumentValue fromString(String value) {
        try {
            return new TbMathArgumentValue(Double.parseDouble(value));
        }
        catch (NumberFormatException ne) {
            throw new RuntimeException("Can't convert value '" + value + "' to double!");
        }
    }

    public double getValue() {
        return this.value;
    }
}

