/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mail;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbEmail;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.mail.TbMsgToEmailNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.TRANSFORMATION, name="to email", configClazz=TbMsgToEmailNodeConfiguration.class, nodeDescription="Transforms message to email message", nodeDetails="Transforms message to email message by populating email fields using values derived from message metadata. Set 'SEND_EMAIL' output message type.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeToEmailConfig", icon="email")
public class TbMsgToEmailNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgToEmailNode.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String IMAGES = "images";
    private static final String DYNAMIC = "dynamic";
    private TbMsgToEmailNodeConfiguration config;
    private boolean isDynamicHtmlTemplate;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgToEmailNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgToEmailNodeConfiguration.class);
        this.isDynamicHtmlTemplate = DYNAMIC.equals(this.config.getMailBodyType());
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            TbEmail email = this.convert(msg);
            TbMsg emailMsg = this.buildEmailMsg(ctx, msg, email);
            ctx.tellNext(emailMsg, TbRelationTypes.SUCCESS);
        }
        catch (Exception ex) {
            log.warn("Can not convert message to email " + ex.getMessage());
            ctx.tellFailure(msg, (Throwable)ex);
        }
    }

    private TbMsg buildEmailMsg(TbContext ctx, TbMsg msg, TbEmail email) throws JsonProcessingException {
        String emailJson = MAPPER.writeValueAsString((Object)email);
        return ctx.transformMsg(msg, "SEND_EMAIL", msg.getOriginator(), msg.getMetaData().copy(), emailJson);
    }

    private TbEmail convert(TbMsg msg) throws IOException {
        TbEmail.TbEmailBuilder builder = TbEmail.builder();
        builder.from(this.fromTemplate(this.config.getFromTemplate(), msg));
        builder.to(this.fromTemplate(this.config.getToTemplate(), msg));
        builder.cc(this.fromTemplate(this.config.getCcTemplate(), msg));
        builder.bcc(this.fromTemplate(this.config.getBccTemplate(), msg));
        if (this.isDynamicHtmlTemplate) {
            builder.html(Boolean.parseBoolean(this.fromTemplate(this.config.getIsHtmlTemplate(), msg)));
        } else {
            builder.html(Boolean.parseBoolean(this.config.getMailBodyType()));
        }
        builder.subject(this.fromTemplate(this.config.getSubjectTemplate(), msg));
        builder.body(this.fromTemplate(this.config.getBodyTemplate(), msg));
        String imagesStr = msg.getMetaData().getValue(IMAGES);
        if (!StringUtils.isEmpty((String)imagesStr)) {
            Map imgMap = (Map)MAPPER.readValue(imagesStr, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            builder.images(imgMap);
        }
        return builder.build();
    }

    private String fromTemplate(String template, TbMsg msg) {
        if (!StringUtils.isEmpty((String)template)) {
            return TbNodeUtils.processPattern((String)template, (TbMsg)msg);
        }
        return null;
    }
}

