/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.geo;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.List;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.geo.Coordinates;
import org.thingsboard.rule.engine.geo.GeoUtil;
import org.thingsboard.rule.engine.geo.Perimeter;
import org.thingsboard.rule.engine.geo.PerimeterType;
import org.thingsboard.rule.engine.geo.RangeUnit;
import org.thingsboard.rule.engine.geo.TbGpsGeofencingFilterNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class AbstractGeofencingNode<T extends TbGpsGeofencingFilterNodeConfiguration>
implements TbNode {
    protected T config;
    protected JtsSpatialContext jtsCtx;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGpsGeofencingFilterNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, this.getConfigClazz());
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.normWrapLongitude = true;
        this.jtsCtx = factory.newSpatialContext();
    }

    protected abstract Class<T> getConfigClazz();

    protected boolean checkMatches(TbMsg msg) throws TbNodeException {
        JsonElement msgDataElement = new JsonParser().parse(msg.getData());
        if (!msgDataElement.isJsonObject()) {
            throw new TbNodeException("Incoming Message is not a valid JSON object");
        }
        JsonObject msgDataObj = msgDataElement.getAsJsonObject();
        double latitude = this.getValueFromMessageByName(msg, msgDataObj, ((TbGpsGeofencingFilterNodeConfiguration)this.config).getLatitudeKeyName());
        double longitude = this.getValueFromMessageByName(msg, msgDataObj, ((TbGpsGeofencingFilterNodeConfiguration)this.config).getLongitudeKeyName());
        List<Perimeter> perimeters = this.getPerimeters(msg, msgDataObj);
        boolean matches = false;
        for (Perimeter perimeter : perimeters) {
            if (!this.checkMatches(perimeter, latitude, longitude)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    protected boolean checkMatches(Perimeter perimeter, double latitude, double longitude) throws TbNodeException {
        if (perimeter.getPerimeterType() == PerimeterType.CIRCLE) {
            Coordinates entityCoordinates = new Coordinates(latitude, longitude);
            Coordinates perimeterCoordinates = new Coordinates(perimeter.getCenterLatitude(), perimeter.getCenterLongitude());
            return perimeter.getRange() > GeoUtil.distance(entityCoordinates, perimeterCoordinates, perimeter.getRangeUnit());
        }
        if (perimeter.getPerimeterType() == PerimeterType.POLYGON) {
            return GeoUtil.contains(perimeter.getPolygonsDefinition(), new Coordinates(latitude, longitude));
        }
        throw new TbNodeException("Unsupported perimeter type: " + perimeter.getPerimeterType());
    }

    protected List<Perimeter> getPerimeters(TbMsg msg, JsonObject msgDataObj) throws TbNodeException {
        if (((TbGpsGeofencingFilterNodeConfiguration)this.config).isFetchPerimeterInfoFromMessageMetadata()) {
            if (StringUtils.isEmpty((String)((TbGpsGeofencingFilterNodeConfiguration)this.config).getPerimeterKeyName())) {
                String perimeterValue = msg.getMetaData().getValue("perimeter");
                if (!StringUtils.isEmpty((String)perimeterValue)) {
                    Perimeter perimeter = new Perimeter();
                    perimeter.setPerimeterType(PerimeterType.POLYGON);
                    perimeter.setPolygonsDefinition(perimeterValue);
                    return Collections.singletonList(perimeter);
                }
                if (!StringUtils.isEmpty((String)msg.getMetaData().getValue("centerLatitude"))) {
                    Perimeter perimeter = new Perimeter();
                    perimeter.setPerimeterType(PerimeterType.CIRCLE);
                    perimeter.setCenterLatitude(Double.parseDouble(msg.getMetaData().getValue("centerLatitude")));
                    perimeter.setCenterLongitude(Double.parseDouble(msg.getMetaData().getValue("centerLongitude")));
                    perimeter.setRange(Double.parseDouble(msg.getMetaData().getValue("range")));
                    perimeter.setRangeUnit(RangeUnit.valueOf(msg.getMetaData().getValue("rangeUnit")));
                    return Collections.singletonList(perimeter);
                }
                throw new TbNodeException("Missing perimeter definition!");
            }
            String perimeterValue = msg.getMetaData().getValue(((TbGpsGeofencingFilterNodeConfiguration)this.config).getPerimeterKeyName());
            if (!StringUtils.isEmpty((String)perimeterValue)) {
                if (((TbGpsGeofencingFilterNodeConfiguration)this.config).getPerimeterType().equals((Object)PerimeterType.POLYGON)) {
                    Perimeter perimeter = new Perimeter();
                    perimeter.setPerimeterType(PerimeterType.POLYGON);
                    perimeter.setPolygonsDefinition(perimeterValue);
                    return Collections.singletonList(perimeter);
                }
                JsonNode circleDef = JacksonUtil.toJsonNode((String)perimeterValue);
                Perimeter perimeter = new Perimeter();
                perimeter.setPerimeterType(PerimeterType.CIRCLE);
                perimeter.setCenterLatitude(circleDef.get("latitude").asDouble());
                perimeter.setCenterLongitude(circleDef.get("longitude").asDouble());
                perimeter.setRange(circleDef.get("radius").asDouble());
                perimeter.setRangeUnit(circleDef.has("radiusUnit") ? RangeUnit.valueOf(circleDef.get("radiusUnit").asText()) : RangeUnit.METER);
                return Collections.singletonList(perimeter);
            }
            throw new TbNodeException("Missing perimeter definition!");
        }
        Perimeter perimeter = new Perimeter();
        perimeter.setPerimeterType(((TbGpsGeofencingFilterNodeConfiguration)this.config).getPerimeterType());
        perimeter.setCenterLatitude(((TbGpsGeofencingFilterNodeConfiguration)this.config).getCenterLatitude());
        perimeter.setCenterLongitude(((TbGpsGeofencingFilterNodeConfiguration)this.config).getCenterLongitude());
        perimeter.setRange(((TbGpsGeofencingFilterNodeConfiguration)this.config).getRange());
        perimeter.setRangeUnit(((TbGpsGeofencingFilterNodeConfiguration)this.config).getRangeUnit());
        perimeter.setPolygonsDefinition(((TbGpsGeofencingFilterNodeConfiguration)this.config).getPolygonsDefinition());
        return Collections.singletonList(perimeter);
    }

    protected Double getValueFromMessageByName(TbMsg msg, JsonObject msgDataObj, String keyName) throws TbNodeException {
        double value;
        if (msgDataObj.has(keyName) && msgDataObj.get(keyName).isJsonPrimitive()) {
            value = msgDataObj.get(keyName).getAsDouble();
        } else {
            String valueStr = msg.getMetaData().getValue(keyName);
            if (!StringUtils.isEmpty((String)valueStr)) {
                value = Double.parseDouble(valueStr);
            } else {
                throw new TbNodeException("Incoming Message has no " + keyName + " in data or metadata!");
            }
        }
        return value;
    }
}

