/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FLOW, name="output", configClazz=EmptyNodeConfiguration.class, nodeDescription="transfers the message to the caller rule chain", nodeDetails="Produces output of the rule chain processing. The output is forwarded to the caller rule chain, as an output of the corresponding \"input\" rule node. The output rule node name corresponds to the relation type of the output message, and it is used to forward messages to other rule nodes in the caller rule chain. ", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFlowNodeRuleChainOutputConfig", outEnabled=false)
public class TbRuleChainOutputNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbRuleChainOutputNode.class);

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.output(msg, ctx.getSelf().getName());
    }
}

