/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.filter.TbAbstractTypeSwitchNode;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.FILTER, name="entity type switch", configClazz=EmptyNodeConfiguration.class, relationTypes={"Device", "Asset", "Alarm", "Entity View", "Tenant", "Customer", "User", "Dashboard", "Rule chain", "Rule node", "Edge"}, nodeDescription="Route incoming messages by Message Originator Type", nodeDetails="Routes messages to chain according to the entity type ('Device', 'Asset', etc.).", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig")
public class TbOriginatorTypeSwitchNode
extends TbAbstractTypeSwitchNode {
    private static final Logger log = LoggerFactory.getLogger(TbOriginatorTypeSwitchNode.class);

    @Override
    protected String getRelationType(TbContext ctx, EntityId originator) throws TbNodeException {
        String relationType;
        EntityType originatorType = originator.getEntityType();
        switch (originatorType) {
            case TENANT: {
                relationType = "Tenant";
                break;
            }
            case CUSTOMER: {
                relationType = "Customer";
                break;
            }
            case USER: {
                relationType = "User";
                break;
            }
            case DASHBOARD: {
                relationType = "Dashboard";
                break;
            }
            case ASSET: {
                relationType = "Asset";
                break;
            }
            case DEVICE: {
                relationType = "Device";
                break;
            }
            case ENTITY_VIEW: {
                relationType = "Entity View";
                break;
            }
            case EDGE: {
                relationType = "Edge";
                break;
            }
            case RULE_CHAIN: {
                relationType = "Rule chain";
                break;
            }
            case RULE_NODE: {
                relationType = "Rule node";
                break;
            }
            case ALARM: {
                relationType = "Alarm";
                break;
            }
            default: {
                throw new TbNodeException("Unsupported originator type: " + originatorType);
            }
        }
        return relationType;
    }
}

