/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbCheckRelationNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="check relation", configClazz=TbCheckRelationNodeConfiguration.class, relationTypes={"True", "False"}, nodeDescription="Checks the presence of the relation between the originator of the message and other entities.", nodeDetails="If 'check relation to specific entity' is selected, one must specify a related entity. Otherwise, the rule node checks the presence of a relation to any entity that matches the direction and relation type criteria.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeCheckRelationConfig")
public class TbCheckRelationNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckRelationNode.class);
    private TbCheckRelationNodeConfiguration config;
    private EntityId singleEntityId;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCheckRelationNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCheckRelationNodeConfiguration.class);
        if (this.config.isCheckForSingleEntity()) {
            this.singleEntityId = EntityIdFactory.getByTypeAndId((String)this.config.getEntityType(), (String)this.config.getEntityId());
            ctx.checkTenantEntity(this.singleEntityId);
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        ListenableFuture<Boolean> checkRelationFuture = this.config.isCheckForSingleEntity() ? this.processSingle(ctx, msg) : this.processList(ctx, msg);
        DonAsynchron.withCallback(checkRelationFuture, filterResult -> ctx.tellNext(msg, filterResult != false ? "True" : "False"), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processSingle(TbContext ctx, TbMsg msg) {
        EntityId to;
        EntityId from;
        if (EntitySearchDirection.FROM.name().equals(this.config.getDirection())) {
            from = this.singleEntityId;
            to = msg.getOriginator();
        } else {
            to = this.singleEntityId;
            from = msg.getOriginator();
        }
        return ctx.getRelationService().checkRelationAsync(ctx.getTenantId(), from, to, this.config.getRelationType(), RelationTypeGroup.COMMON);
    }

    private ListenableFuture<Boolean> processList(TbContext ctx, TbMsg msg) {
        if (EntitySearchDirection.FROM.name().equals(this.config.getDirection())) {
            return Futures.transformAsync((ListenableFuture)ctx.getRelationService().findByToAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), this.config.getRelationType(), RelationTypeGroup.COMMON), this::isEmptyList, (Executor)MoreExecutors.directExecutor());
        }
        return Futures.transformAsync((ListenableFuture)ctx.getRelationService().findByFromAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), this.config.getRelationType(), RelationTypeGroup.COMMON), this::isEmptyList, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Boolean> isEmptyList(List<EntityRelation> entityRelations) {
        if (entityRelations.isEmpty()) {
            return Futures.immediateFuture((Object)false);
        }
        return Futures.immediateFuture((Object)true);
    }
}

