/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.edge;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.edge.BaseTbMsgPushNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;

public abstract class AbstractTbMsgPushNode<T extends BaseTbMsgPushNodeConfiguration, S, U>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(AbstractTbMsgPushNode.class);
    protected T config;
    private static final String SCOPE = "scope";

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (BaseTbMsgPushNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, this.getConfigClazz());
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (this.getIgnoredMessageSource().equalsIgnoreCase(msg.getMetaData().getValue("source"))) {
            log.debug("Ignoring msg from the {}, msg [{}]", (Object)this.getIgnoredMessageSource(), (Object)msg);
            ctx.ack(msg);
            return;
        }
        if (this.isSupportedOriginator(msg.getOriginator().getEntityType())) {
            if (this.isSupportedMsgType(msg.getType())) {
                this.processMsg(ctx, msg);
            } else {
                String errMsg = String.format("Unsupported msg type %s", msg.getType());
                log.debug(errMsg);
                ctx.tellFailure(msg, (Throwable)new RuntimeException(errMsg));
            }
        } else {
            String errMsg = String.format("Unsupported originator type %s", msg.getOriginator().getEntityType());
            log.debug(errMsg);
            ctx.tellFailure(msg, (Throwable)new RuntimeException(errMsg));
        }
    }

    protected S buildEvent(TbMsg msg, TbContext ctx) {
        String msgType = msg.getType();
        if ("ALARM".equals(msgType)) {
            EdgeEventActionType actionType = AbstractTbMsgPushNode.getAlarmActionType(msg);
            return this.buildEvent(ctx.getTenantId(), actionType, this.getUUIDFromMsgData(msg), this.getAlarmEventType(), null);
        }
        Map metadata = msg.getMetaData().getData();
        EdgeEventActionType actionType = this.getEdgeEventActionTypeByMsgType(msgType, metadata);
        HashMap<String, Object> entityBody = new HashMap<String, Object>();
        JsonNode dataJson = JacksonUtil.toJsonNode((String)msg.getData());
        switch (actionType) {
            case ATTRIBUTES_UPDATED: 
            case POST_ATTRIBUTES: {
                entityBody.put("kv", dataJson);
                entityBody.put(SCOPE, this.getScope(metadata));
                if (!EdgeEventActionType.POST_ATTRIBUTES.equals((Object)actionType)) break;
                entityBody.put("isPostAttributes", true);
                break;
            }
            case ATTRIBUTES_DELETED: {
                List keys = (List)JacksonUtil.convertValue((Object)dataJson.get("attributes"), (TypeReference)new TypeReference<List<String>>(){});
                entityBody.put("keys", keys);
                entityBody.put(SCOPE, this.getScope(metadata));
                break;
            }
            case TIMESERIES_UPDATED: {
                entityBody.put("data", dataJson);
                entityBody.put("ts", msg.getMetaDataTs());
            }
        }
        return this.buildEvent(ctx.getTenantId(), actionType, msg.getOriginator().getId(), this.getEventTypeByEntityType(msg.getOriginator().getEntityType()), JacksonUtil.valueToTree(entityBody));
    }

    private static EdgeEventActionType getAlarmActionType(TbMsg msg) {
        boolean isNewAlarm = Boolean.parseBoolean(msg.getMetaData().getValue("isNewAlarm"));
        boolean isClearedAlarm = Boolean.parseBoolean(msg.getMetaData().getValue("isClearedAlarm"));
        EdgeEventActionType eventAction = isNewAlarm ? EdgeEventActionType.ADDED : (isClearedAlarm ? EdgeEventActionType.ALARM_CLEAR : EdgeEventActionType.UPDATED);
        return eventAction;
    }

    abstract S buildEvent(TenantId var1, EdgeEventActionType var2, UUID var3, U var4, JsonNode var5);

    abstract U getEventTypeByEntityType(EntityType var1);

    abstract U getAlarmEventType();

    abstract String getIgnoredMessageSource();

    protected abstract Class<T> getConfigClazz();

    abstract void processMsg(TbContext var1, TbMsg var2);

    protected UUID getUUIDFromMsgData(TbMsg msg) {
        JsonNode data = JacksonUtil.toJsonNode((String)msg.getData()).get("id");
        String id = (String)JacksonUtil.convertValue((Object)data.get("id"), String.class);
        return UUID.fromString(id);
    }

    protected String getScope(Map<String, String> metadata) {
        String scope = metadata.get(SCOPE);
        if (StringUtils.isEmpty((String)scope)) {
            scope = ((BaseTbMsgPushNodeConfiguration)this.config).getScope();
        }
        return scope;
    }

    protected EdgeEventActionType getEdgeEventActionTypeByMsgType(String msgType, Map<String, String> metadata) {
        EdgeEventActionType actionType;
        if (SessionMsgType.POST_TELEMETRY_REQUEST.name().equals(msgType) || "TIMESERIES_UPDATED".equals(msgType)) {
            actionType = EdgeEventActionType.TIMESERIES_UPDATED;
        } else if ("ATTRIBUTES_UPDATED".equals(msgType)) {
            actionType = EdgeEventActionType.ATTRIBUTES_UPDATED;
        } else if (SessionMsgType.POST_ATTRIBUTES_REQUEST.name().equals(msgType)) {
            actionType = EdgeEventActionType.POST_ATTRIBUTES;
        } else if ("ATTRIBUTES_DELETED".equals(msgType)) {
            actionType = EdgeEventActionType.ATTRIBUTES_DELETED;
        } else if ("CONNECT_EVENT".equals(msgType) || "DISCONNECT_EVENT".equals(msgType) || "ACTIVITY_EVENT".equals(msgType) || "INACTIVITY_EVENT".equals(msgType)) {
            String scope = metadata.get(SCOPE);
            actionType = StringUtils.isEmpty((String)scope) ? EdgeEventActionType.TIMESERIES_UPDATED : EdgeEventActionType.ATTRIBUTES_UPDATED;
        } else {
            log.warn("Unsupported msg type [{}]", (Object)msgType);
            throw new IllegalArgumentException("Unsupported msg type: " + msgType);
        }
        return actionType;
    }

    protected boolean isSupportedMsgType(String msgType) {
        return SessionMsgType.POST_TELEMETRY_REQUEST.name().equals(msgType) || SessionMsgType.POST_ATTRIBUTES_REQUEST.name().equals(msgType) || "ATTRIBUTES_UPDATED".equals(msgType) || "ATTRIBUTES_DELETED".equals(msgType) || "TIMESERIES_UPDATED".equals(msgType) || "ALARM".equals(msgType) || "CONNECT_EVENT".equals(msgType) || "DISCONNECT_EVENT".equals(msgType) || "ACTIVITY_EVENT".equals(msgType) || "INACTIVITY_EVENT".equals(msgType);
    }

    protected boolean isSupportedOriginator(EntityType entityType) {
        switch (entityType) {
            case DEVICE: 
            case ASSET: 
            case ENTITY_VIEW: 
            case DASHBOARD: 
            case TENANT: 
            case CUSTOMER: 
            case USER: 
            case EDGE: {
                return true;
            }
        }
        return false;
    }
}

