/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractAlarmNode;
import org.thingsboard.rule.engine.action.TbAlarmResult;
import org.thingsboard.rule.engine.action.TbCreateAlarmNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="create alarm", relationTypes={"Created", "Updated", "False"}, configClazz=TbCreateAlarmNodeConfiguration.class, nodeDescription="Create or Update Alarm", nodeDetails="Details - JS function that creates JSON object based on incoming message. This object will be added into Alarm.details field.\nNode output:\nIf alarm was not created, original message is returned. Otherwise new Message returned with type 'ALARM', Alarm object in 'msg' property and 'metadata' will contains one of those properties 'isNewAlarm/isExistingAlarm'. Message payload can be accessed via <code>msg</code> property. For example <code>'temperature = ' + msg.temperature ;</code>. Message metadata can be accessed via <code>metadata</code> property. For example <code>'name = ' + metadata.customerName;</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeCreateAlarmConfig", icon="notifications_active")
public class TbCreateAlarmNode
extends TbAbstractAlarmNode<TbCreateAlarmNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbCreateAlarmNode.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private List<String> relationTypes;
    private AlarmSeverity notDynamicAlarmSeverity;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        super.init(ctx, configuration);
        if (!((TbCreateAlarmNodeConfiguration)this.config).isDynamicSeverity()) {
            this.notDynamicAlarmSeverity = (AlarmSeverity)EnumUtils.getEnum(AlarmSeverity.class, (String)((TbCreateAlarmNodeConfiguration)this.config).getSeverity());
            if (this.notDynamicAlarmSeverity == null) {
                throw new TbNodeException("Incorrect Alarm Severity value: " + ((TbCreateAlarmNodeConfiguration)this.config).getSeverity());
            }
        }
    }

    @Override
    protected TbCreateAlarmNodeConfiguration loadAlarmNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        TbCreateAlarmNodeConfiguration nodeConfiguration = (TbCreateAlarmNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCreateAlarmNodeConfiguration.class);
        this.relationTypes = nodeConfiguration.getRelationTypes();
        return nodeConfiguration;
    }

    @Override
    protected ListenableFuture<TbAlarmResult> processAlarm(TbContext ctx, TbMsg msg) {
        Alarm msgAlarm;
        String alarmType;
        if (!((TbCreateAlarmNodeConfiguration)this.config).isUseMessageAlarmData()) {
            alarmType = TbNodeUtils.processPattern((String)((TbCreateAlarmNodeConfiguration)this.config).getAlarmType(), (TbMsg)msg);
            msgAlarm = null;
        } else {
            try {
                msgAlarm = this.getAlarmFromMessage(ctx, msg);
                alarmType = msgAlarm.getType();
            }
            catch (IOException e) {
                ctx.tellFailure(msg, (Throwable)e);
                return null;
            }
        }
        Alarm existingAlarm = ctx.getAlarmService().findLatestActiveByOriginatorAndType(ctx.getTenantId(), msg.getOriginator(), alarmType);
        if (existingAlarm == null || existingAlarm.getStatus().isCleared()) {
            return this.createNewAlarm(ctx, msg, msgAlarm);
        }
        return this.updateAlarm(ctx, msg, existingAlarm, msgAlarm);
    }

    private Alarm getAlarmFromMessage(TbContext ctx, TbMsg msg) throws IOException {
        Alarm msgAlarm = (Alarm)mapper.readValue(msg.getData(), Alarm.class);
        msgAlarm.setTenantId(ctx.getTenantId());
        if (msgAlarm.getOriginator() == null) {
            msgAlarm.setOriginator(msg.getOriginator());
        }
        return msgAlarm;
    }

    private ListenableFuture<TbAlarmResult> createNewAlarm(TbContext ctx, TbMsg msg, Alarm msgAlarm) {
        ListenableFuture<JsonNode> asyncDetails;
        boolean buildDetails;
        boolean bl = buildDetails = !((TbCreateAlarmNodeConfiguration)this.config).isUseMessageAlarmData() || ((TbCreateAlarmNodeConfiguration)this.config).isOverwriteAlarmDetails();
        if (buildDetails) {
            ctx.logJsEvalRequest();
            asyncDetails = this.buildAlarmDetails(ctx, msg, null);
        } else {
            asyncDetails = Futures.immediateFuture(null);
        }
        ListenableFuture asyncAlarm = Futures.transform(asyncDetails, details -> {
            Alarm newAlarm;
            if (buildDetails) {
                ctx.logJsEvalResponse();
            }
            if (msgAlarm != null) {
                newAlarm = msgAlarm;
                if (buildDetails) {
                    newAlarm.setDetails(details);
                }
            } else {
                newAlarm = this.buildAlarm(msg, (JsonNode)details, ctx.getTenantId());
            }
            return newAlarm;
        }, (Executor)MoreExecutors.directExecutor());
        ListenableFuture asyncCreated = Futures.transform((ListenableFuture)asyncAlarm, alarm -> ctx.getAlarmService().createAlarm(AlarmCreateOrUpdateActiveRequest.fromAlarm((Alarm)alarm)), (Executor)ctx.getDbCallbackExecutor());
        return Futures.transform((ListenableFuture)asyncCreated, TbAlarmResult::fromAlarmResult, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<TbAlarmResult> updateAlarm(TbContext ctx, TbMsg msg, Alarm existingAlarm, Alarm msgAlarm) {
        ListenableFuture<JsonNode> asyncDetails;
        boolean buildDetails;
        boolean bl = buildDetails = !((TbCreateAlarmNodeConfiguration)this.config).isUseMessageAlarmData() || ((TbCreateAlarmNodeConfiguration)this.config).isOverwriteAlarmDetails();
        if (buildDetails) {
            ctx.logJsEvalRequest();
            asyncDetails = this.buildAlarmDetails(ctx, msg, existingAlarm.getDetails());
        } else {
            asyncDetails = Futures.immediateFuture(null);
        }
        ListenableFuture asyncUpdated = Futures.transform(asyncDetails, details -> {
            if (buildDetails) {
                ctx.logJsEvalResponse();
            }
            if (msgAlarm != null) {
                existingAlarm.setSeverity(msgAlarm.getSeverity());
                existingAlarm.setPropagate(msgAlarm.isPropagate());
                existingAlarm.setPropagateToOwner(msgAlarm.isPropagateToOwner());
                existingAlarm.setPropagateToTenant(msgAlarm.isPropagateToTenant());
                existingAlarm.setPropagateRelationTypes(msgAlarm.getPropagateRelationTypes());
                if (buildDetails) {
                    existingAlarm.setDetails(details);
                } else {
                    existingAlarm.setDetails(msgAlarm.getDetails());
                }
            } else {
                existingAlarm.setSeverity(this.processAlarmSeverity(msg));
                existingAlarm.setPropagate(((TbCreateAlarmNodeConfiguration)this.config).isPropagate());
                existingAlarm.setPropagateToOwner(((TbCreateAlarmNodeConfiguration)this.config).isPropagateToOwner());
                existingAlarm.setPropagateToTenant(((TbCreateAlarmNodeConfiguration)this.config).isPropagateToTenant());
                existingAlarm.setPropagateRelationTypes(this.relationTypes);
                existingAlarm.setDetails(details);
            }
            existingAlarm.setEndTs(System.currentTimeMillis());
            return ctx.getAlarmService().updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)existingAlarm));
        }, (Executor)ctx.getDbCallbackExecutor());
        return Futures.transform((ListenableFuture)asyncUpdated, TbAlarmResult::fromAlarmResult, (Executor)MoreExecutors.directExecutor());
    }

    private Alarm buildAlarm(TbMsg msg, JsonNode details, TenantId tenantId) {
        long ts = msg.getMetaDataTs();
        return Alarm.builder().tenantId(tenantId).originator(msg.getOriginator()).cleared(false).acknowledged(false).severity(((TbCreateAlarmNodeConfiguration)this.config).isDynamicSeverity() ? this.processAlarmSeverity(msg) : this.notDynamicAlarmSeverity).propagate(((TbCreateAlarmNodeConfiguration)this.config).isPropagate()).propagateToOwner(((TbCreateAlarmNodeConfiguration)this.config).isPropagateToOwner()).propagateToTenant(((TbCreateAlarmNodeConfiguration)this.config).isPropagateToTenant()).type(TbNodeUtils.processPattern((String)((TbCreateAlarmNodeConfiguration)this.config).getAlarmType(), (TbMsg)msg)).propagateRelationTypes(this.relationTypes).startTs(ts).endTs(ts).details(details).build();
    }

    private AlarmSeverity processAlarmSeverity(TbMsg msg) {
        AlarmSeverity severity = (AlarmSeverity)EnumUtils.getEnum(AlarmSeverity.class, (String)TbNodeUtils.processPattern((String)((TbCreateAlarmNodeConfiguration)this.config).getSeverity(), (TbMsg)msg));
        if (severity == null) {
            throw new RuntimeException("Used incorrect pattern or Alarm Severity not included in message");
        }
        return severity;
    }
}

