/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.action.TbAbstractCustomerActionNodeConfiguration;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.dao.customer.CustomerService;

public abstract class TbAbstractCustomerActionNode<C extends TbAbstractCustomerActionNodeConfiguration>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractCustomerActionNode.class);
    protected C config;
    private LoadingCache<CustomerKey, Optional<CustomerId>> customerIdCache;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadCustomerNodeActionConfig(configuration);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (((TbAbstractCustomerActionNodeConfiguration)this.config).getCustomerCacheExpiration() > 0L) {
            cacheBuilder.expireAfterWrite(((TbAbstractCustomerActionNodeConfiguration)this.config).getCustomerCacheExpiration(), TimeUnit.SECONDS);
        }
        this.customerIdCache = cacheBuilder.build((CacheLoader)new CustomerCacheLoader(ctx, this.createCustomerIfNotExists()));
    }

    protected abstract boolean createCustomerIfNotExists();

    protected abstract C loadCustomerNodeActionConfig(TbNodeConfiguration var1) throws TbNodeException;

    public void onMsg(TbContext ctx, TbMsg msg) {
        DonAsynchron.withCallback(this.processCustomerAction(ctx, msg), m -> ctx.tellSuccess(msg), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Void> processCustomerAction(TbContext ctx, TbMsg msg) {
        ListenableFuture<CustomerId> customerIdFeature = this.getCustomer(ctx, msg);
        return Futures.transform(customerIdFeature, customerId -> {
            this.doProcessCustomerAction(ctx, msg, (CustomerId)customerId);
            return null;
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract void doProcessCustomerAction(TbContext var1, TbMsg var2, CustomerId var3);

    protected ListenableFuture<CustomerId> getCustomer(TbContext ctx, TbMsg msg) {
        String customerTitle = TbNodeUtils.processPattern((String)((TbAbstractCustomerActionNodeConfiguration)this.config).getCustomerNamePattern(), (TbMsg)msg);
        CustomerKey key = new CustomerKey(customerTitle);
        return ctx.getDbCallbackExecutor().executeAsync(() -> {
            Optional customerId = (Optional)this.customerIdCache.get((Object)key);
            if (!customerId.isPresent()) {
                throw new RuntimeException("No customer found with name '" + key.getCustomerTitle() + "'.");
            }
            return (CustomerId)customerId.get();
        });
    }

    public void destroy() {
        if (this.customerIdCache != null) {
            this.customerIdCache.invalidateAll();
        }
    }

    private static class CustomerCacheLoader
    extends CacheLoader<CustomerKey, Optional<CustomerId>> {
        private final TbContext ctx;
        private final boolean createIfNotExists;

        private CustomerCacheLoader(TbContext ctx, boolean createIfNotExists) {
            this.ctx = ctx;
            this.createIfNotExists = createIfNotExists;
        }

        public Optional<CustomerId> load(CustomerKey key) {
            CustomerService service = this.ctx.getCustomerService();
            Optional customerOptional = service.findCustomerByTenantIdAndTitle(this.ctx.getTenantId(), key.getCustomerTitle());
            if (customerOptional.isPresent()) {
                return Optional.of(((Customer)customerOptional.get()).getId());
            }
            if (this.createIfNotExists) {
                Customer newCustomer = new Customer();
                newCustomer.setTitle(key.getCustomerTitle());
                newCustomer.setTenantId(this.ctx.getTenantId());
                Customer savedCustomer = service.saveCustomer(newCustomer);
                this.ctx.enqueue(this.ctx.customerCreatedMsg(savedCustomer, this.ctx.getSelfId()), () -> log.trace("Pushed Customer Created message: {}", (Object)savedCustomer), throwable -> log.warn("Failed to push Customer Created message: {}", (Object)savedCustomer, throwable));
                return Optional.of(savedCustomer.getId());
            }
            return Optional.empty();
        }
    }

    private static class CustomerKey {
        private String customerTitle;

        public String getCustomerTitle() {
            return this.customerTitle;
        }

        public void setCustomerTitle(String customerTitle) {
            this.customerTitle = customerTitle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerKey)) {
                return false;
            }
            CustomerKey other = (CustomerKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customerTitle = this.getCustomerTitle();
            String other$customerTitle = other.getCustomerTitle();
            return !(this$customerTitle == null ? other$customerTitle != null : !this$customerTitle.equals(other$customerTitle));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomerKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customerTitle = this.getCustomerTitle();
            result = result * 59 + ($customerTitle == null ? 43 : $customerTitle.hashCode());
            return result;
        }

        public String toString() {
            return "TbAbstractCustomerActionNode.CustomerKey(customerTitle=" + this.getCustomerTitle() + ")";
        }

        @ConstructorProperties(value={"customerTitle"})
        public CustomerKey(String customerTitle) {
            this.customerTitle = customerTitle;
        }
    }
}

