/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UserId;

public class EntitiesCustomerIdAsyncLoader {
    public static ListenableFuture<CustomerId> findEntityIdAsync(TbContext ctx, EntityId original) {
        switch (original.getEntityType()) {
            case CUSTOMER: {
                return Futures.immediateFuture((Object)((CustomerId)original));
            }
            case USER: {
                return EntitiesCustomerIdAsyncLoader.getCustomerAsync(ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), (UserId)original));
            }
            case ASSET: {
                return EntitiesCustomerIdAsyncLoader.getCustomerAsync(ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), (AssetId)original));
            }
            case DEVICE: {
                return EntitiesCustomerIdAsyncLoader.getCustomerAsync(ctx.getDeviceService().findDeviceByIdAsync(ctx.getTenantId(), (DeviceId)original));
            }
        }
        return Futures.immediateFailedFuture((Throwable)new TbNodeException("Unexpected original EntityType " + original.getEntityType()));
    }

    private static <T extends HasCustomerId> ListenableFuture<CustomerId> getCustomerAsync(ListenableFuture<T> future) {
        return Futures.transformAsync(future, in -> in != null ? Futures.immediateFuture((Object)in.getCustomerId()) : Futures.immediateFuture(null), (Executor)MoreExecutors.directExecutor());
    }
}

