/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.rpc;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleEngineDeviceRpcRequest;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.rpc.TbSendRpcRequestNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="rpc call request", configClazz=TbSendRpcRequestNodeConfiguration.class, nodeDescription="Sends RPC call to device", nodeDetails="Expects messages with \"method\" and \"params\". Will forward response from device to next nodes.If the RPC call request is originated by REST API call from user, will forward the response to user immediately.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeRpcRequestConfig", icon="call_made")
public class TbSendRPCRequestNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbSendRPCRequestNode.class);
    private Random random = new Random();
    private Gson gson = new Gson();
    private JsonParser jsonParser = new JsonParser();
    private TbSendRpcRequestNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbSendRpcRequestNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSendRpcRequestNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        JsonObject json = this.jsonParser.parse(msg.getData()).getAsJsonObject();
        if (msg.getOriginator().getEntityType() != EntityType.DEVICE) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Message originator is not a device entity!"));
        } else if (!json.has("method")) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Method is not present in the message!"));
        } else if (!json.has("params")) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Params are not present in the message!"));
        } else {
            int requestId = json.has("requestId") ? json.get("requestId").getAsInt() : this.random.nextInt();
            boolean restApiCall = msg.getType().equals("RPC_CALL_FROM_SERVER_TO_DEVICE");
            String tmp = msg.getMetaData().getValue("oneway");
            boolean oneway = !StringUtils.isEmpty((Object)tmp) && Boolean.parseBoolean(tmp);
            tmp = msg.getMetaData().getValue("persistent");
            boolean persisted = !StringUtils.isEmpty((Object)tmp) && Boolean.parseBoolean(tmp);
            tmp = msg.getMetaData().getValue("requestUUID");
            UUID requestUUID = !StringUtils.isEmpty((Object)tmp) ? UUID.fromString(tmp) : Uuids.timeBased();
            tmp = msg.getMetaData().getValue("originServiceId");
            String originServiceId = !StringUtils.isEmpty((Object)tmp) ? tmp : null;
            tmp = msg.getMetaData().getValue("expirationTime");
            long expirationTime = !StringUtils.isEmpty((Object)tmp) ? Long.parseLong(tmp) : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.config.getTimeoutInSeconds());
            tmp = msg.getMetaData().getValue("retries");
            Integer retries = !StringUtils.isEmpty((Object)tmp) ? Integer.valueOf(Integer.parseInt(tmp)) : null;
            String params = this.parseJsonData(json.get("params"));
            String additionalInfo = this.parseJsonData(json.get("additionalInfo"));
            RuleEngineDeviceRpcRequest request = RuleEngineDeviceRpcRequest.builder().oneway(oneway).method(json.get("method").getAsString()).body(params).tenantId(ctx.getTenantId()).deviceId(new DeviceId(msg.getOriginator().getId())).requestId(requestId).requestUUID(requestUUID).originServiceId(originServiceId).expirationTime(expirationTime).retries(retries).restApiCall(restApiCall).persisted(persisted).additionalInfo(additionalInfo).build();
            ctx.getRpcService().sendRpcRequestToDevice(request, ruleEngineDeviceRpcResponse -> {
                if (ruleEngineDeviceRpcResponse.getError().isEmpty()) {
                    TbMsg next = ctx.newMsg(msg.getQueueName(), msg.getType(), msg.getOriginator(), msg.getCustomerId(), msg.getMetaData(), ruleEngineDeviceRpcResponse.getResponse().orElse("{}"));
                    ctx.enqueueForTellNext(next, TbRelationTypes.SUCCESS);
                } else {
                    TbMsg next = ctx.newMsg(msg.getQueueName(), msg.getType(), msg.getOriginator(), msg.getCustomerId(), msg.getMetaData(), this.wrap("error", ((RpcError)ruleEngineDeviceRpcResponse.getError().get()).name()));
                    ctx.enqueueForTellFailure(next, ((RpcError)ruleEngineDeviceRpcResponse.getError().get()).name());
                }
            });
            ctx.ack(msg);
        }
    }

    public void destroy() {
    }

    private String wrap(String name, String body) {
        JsonObject json = new JsonObject();
        json.addProperty(name, body);
        return this.gson.toJson((JsonElement)json);
    }

    private String parseJsonData(JsonElement paramsEl) {
        if (paramsEl != null) {
            return paramsEl.isJsonPrimitive() ? paramsEl.getAsString() : this.gson.toJson(paramsEl);
        }
        return null;
    }
}

