/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNodeConfiguration;
import org.thingsboard.rule.engine.util.EntityDetails;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractGetEntityDetailsNode<C extends TbAbstractGetEntityDetailsNodeConfiguration>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractGetEntityDetailsNode.class);
    private static final Gson gson = new Gson();
    private static final JsonParser jsonParser = new JsonParser();
    private static final Type TYPE = new TypeToken<Map<String, String>>(){}.getType();
    protected C config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadGetEntityDetailsNodeConfiguration(configuration);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        DonAsynchron.withCallback(this.getDetails(ctx, msg), arg_0 -> ((TbContext)ctx).tellSuccess(arg_0), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    public void destroy() {
    }

    protected abstract C loadGetEntityDetailsNodeConfiguration(TbNodeConfiguration var1) throws TbNodeException;

    protected abstract ListenableFuture<TbMsg> getDetails(TbContext var1, TbMsg var2);

    protected abstract ListenableFuture<ContactBased> getContactBasedListenableFuture(TbContext var1, TbMsg var2);

    protected MessageData getDataAsJson(TbMsg msg) {
        if (((TbAbstractGetEntityDetailsNodeConfiguration)this.config).isAddToMetadata()) {
            return new MessageData(gson.toJsonTree((Object)msg.getMetaData().getData(), TYPE), "metadata");
        }
        return new MessageData(jsonParser.parse(msg.getData()), "data");
    }

    protected ListenableFuture<TbMsg> getTbMsgListenableFuture(TbContext ctx, TbMsg msg, MessageData messageData, String prefix) {
        if (!((TbAbstractGetEntityDetailsNodeConfiguration)this.config).getDetailsList().isEmpty()) {
            ListenableFuture<ContactBased> contactBasedListenableFuture = this.getContactBasedListenableFuture(ctx, msg);
            ListenableFuture<JsonElement> resultObject = this.addContactProperties(messageData.getData(), contactBasedListenableFuture, prefix);
            return this.transformMsg(ctx, msg, resultObject, messageData);
        }
        return Futures.immediateFuture((Object)msg);
    }

    private ListenableFuture<TbMsg> transformMsg(TbContext ctx, TbMsg msg, ListenableFuture<JsonElement> propertiesFuture, MessageData messageData) {
        return Futures.transformAsync(propertiesFuture, jsonElement -> {
            if (jsonElement != null) {
                if (messageData.getDataType().equals("metadata")) {
                    Map metadataMap = (Map)gson.fromJson(jsonElement.toString(), TYPE);
                    return Futures.immediateFuture((Object)ctx.transformMsg(msg, msg.getType(), msg.getOriginator(), new TbMsgMetaData(metadataMap), msg.getData()));
                }
                return Futures.immediateFuture((Object)ctx.transformMsg(msg, msg.getType(), msg.getOriginator(), msg.getMetaData(), gson.toJson(jsonElement)));
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<JsonElement> addContactProperties(JsonElement data, ListenableFuture<ContactBased> entityFuture, String prefix) {
        return Futures.transformAsync(entityFuture, contactBased -> {
            if (contactBased != null) {
                JsonElement jsonElement = null;
                for (EntityDetails entityDetails : ((TbAbstractGetEntityDetailsNodeConfiguration)this.config).getDetailsList()) {
                    jsonElement = this.setProperties((ContactBased)contactBased, data, entityDetails, prefix);
                }
                return Futures.immediateFuture(jsonElement);
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private JsonElement setProperties(ContactBased entity, JsonElement data, EntityDetails entityDetails, String prefix) {
        JsonObject dataAsObject = data.getAsJsonObject();
        switch (entityDetails) {
            case TITLE: {
                dataAsObject.addProperty(prefix + "title", entity.getName());
                break;
            }
            case ADDRESS: {
                if (entity.getAddress() == null) break;
                dataAsObject.addProperty(prefix + "address", entity.getAddress());
                break;
            }
            case ADDRESS2: {
                if (entity.getAddress2() == null) break;
                dataAsObject.addProperty(prefix + "address2", entity.getAddress2());
                break;
            }
            case CITY: {
                if (entity.getCity() == null) break;
                dataAsObject.addProperty(prefix + "city", entity.getCity());
                break;
            }
            case COUNTRY: {
                if (entity.getCountry() == null) break;
                dataAsObject.addProperty(prefix + "country", entity.getCountry());
                break;
            }
            case STATE: {
                if (entity.getState() == null) break;
                dataAsObject.addProperty(prefix + "state", entity.getState());
                break;
            }
            case EMAIL: {
                if (entity.getEmail() == null) break;
                dataAsObject.addProperty(prefix + "email", entity.getEmail());
                break;
            }
            case PHONE: {
                if (entity.getPhone() == null) break;
                dataAsObject.addProperty(prefix + "phone", entity.getPhone());
                break;
            }
            case ZIP: {
                if (entity.getZip() == null) break;
                dataAsObject.addProperty(prefix + "zip", entity.getZip());
                break;
            }
            case ADDITIONAL_INFO: {
                if (!entity.getAdditionalInfo().hasNonNull("description")) break;
                dataAsObject.addProperty(prefix + "additionalInfo", entity.getAdditionalInfo().get("description").asText());
            }
        }
        return dataAsObject;
    }

    private static class MessageData {
        private JsonElement data;
        private String dataType;

        public JsonElement getData() {
            return this.data;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setData(JsonElement data) {
            this.data = data;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageData)) {
                return false;
            }
            MessageData other = (MessageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JsonElement this$data = this.getData();
            JsonElement other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$dataType = this.getDataType();
            String other$dataType = other.getDataType();
            return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JsonElement $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            return result;
        }

        public String toString() {
            return "TbAbstractGetEntityDetailsNode.MessageData(data=" + this.getData() + ", dataType=" + this.getDataType() + ")";
        }

        @ConstructorProperties(value={"data", "dataType"})
        public MessageData(JsonElement data, String dataType) {
            this.data = data;
            this.dataType = dataType;
        }
    }
}

