/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FLOW, name="acknowledge", configClazz=EmptyNodeConfiguration.class, nodeDescription="Acknowledges the incoming message", nodeDetails="After acknowledgement, the message is pushed to related rule nodes. Useful if you don't care what happens to this message next.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig")
public class TbAckNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAckNode.class);
    EmptyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (EmptyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, EmptyNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.ack(msg);
        ctx.tellSuccess(msg);
    }

    public void destroy() {
    }
}

