/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbJsSwitchNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="switch", customRelations=true, relationTypes={}, configClazz=TbJsSwitchNodeConfiguration.class, nodeDescription="Route incoming Message to one or multiple output chains", nodeDetails="Node executes configured JS script. Script should return array of next Chain names where Message should be routed. If Array is empty - message not routed to next Node. Message payload can be accessed via <code>msg</code> property. For example <code>msg.temperature < 10;</code><br/>Message metadata can be accessed via <code>metadata</code> property. For example <code>metadata.customerName === 'John';</code><br/>Message type can be accessed via <code>msgType</code> property.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeSwitchConfig")
public class TbJsSwitchNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbJsSwitchNode.class);
    private TbJsSwitchNodeConfiguration config;
    private ScriptEngine jsEngine;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbJsSwitchNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbJsSwitchNodeConfiguration.class);
        this.jsEngine = ctx.createJsScriptEngine(this.config.getJsScript(), new String[0]);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) {
        ctx.logJsEvalRequest();
        Futures.addCallback((ListenableFuture)this.jsEngine.executeSwitchAsync(msg), (FutureCallback)new FutureCallback<Set<String>>(){

            public void onSuccess(@Nullable Set<String> result) {
                ctx.logJsEvalResponse();
                TbJsSwitchNode.this.processSwitch(ctx, msg, result);
            }

            public void onFailure(Throwable t) {
                ctx.logJsEvalFailure();
                ctx.tellFailure(msg, t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void processSwitch(TbContext ctx, TbMsg msg, Set<String> nextRelations) {
        ctx.tellNext(msg, nextRelations);
    }

    public void destroy() {
        if (this.jsEngine != null) {
            this.jsEngine.destroy();
        }
    }
}

