/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbCheckAlarmStatusNodeConfig;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="check alarm status", configClazz=TbCheckAlarmStatusNodeConfig.class, relationTypes={"True", "False"}, nodeDescription="Checks alarm status.", nodeDetails="If the alarm status matches the specified one - msg is success if does not match - msg is failure.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeCheckAlarmStatusConfig")
public class TbCheckAlarmStatusNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckAlarmStatusNode.class);
    private TbCheckAlarmStatusNodeConfig config;
    private final ObjectMapper mapper = new ObjectMapper();

    public void init(TbContext tbContext, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCheckAlarmStatusNodeConfig)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCheckAlarmStatusNodeConfig.class);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) throws TbNodeException {
        try {
            Alarm alarm = (Alarm)this.mapper.readValue(msg.getData(), Alarm.class);
            ListenableFuture latest = ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), alarm.getId());
            Futures.addCallback((ListenableFuture)latest, (FutureCallback)new FutureCallback<Alarm>(){

                public void onSuccess(@Nullable Alarm result) {
                    if (result != null) {
                        boolean isPresent = false;
                        for (AlarmStatus alarmStatus : TbCheckAlarmStatusNode.this.config.getAlarmStatusList()) {
                            if (result.getStatus() != alarmStatus) continue;
                            isPresent = true;
                            break;
                        }
                        if (isPresent) {
                            ctx.tellNext(msg, "True");
                        } else {
                            ctx.tellNext(msg, "False");
                        }
                    } else {
                        ctx.tellFailure(msg, (Throwable)new TbNodeException("No such alarm found."));
                    }
                }

                public void onFailure(Throwable t) {
                    ctx.tellFailure(msg, t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (IOException e) {
            log.error("Failed to parse alarm: [{}]", (Object)msg.getData());
            throw new TbNodeException((Exception)e);
        }
    }

    public void destroy() {
    }
}

