/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.edge;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.edge.TbMsgPushToEdgeNodeConfiguration;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;

@RuleNode(type=ComponentType.ACTION, name="push to edge", configClazz=TbMsgPushToEdgeNodeConfiguration.class, nodeDescription="Push messages from cloud to edge", nodeDetails="Push messages from cloud to edge. Message originator must be assigned to particular edge or message originator is <b>EDGE</b> entity itself. This node used only on cloud instances to push messages from cloud to edge. Once message arrived into this node it\u2019s going to be converted into edge event and saved to the database. Node doesn't push messages directly to edge, but stores event(s) in the edge queue. <br>Supports next originator types:<br><code>DEVICE</code><br><code>ASSET</code><br><code>ENTITY_VIEW</code><br><code>DASHBOARD</code><br><code>TENANT</code><br><code>CUSTOMER</code><br><code>EDGE</code><br><br>As well node supports next message types:<br><code>POST_TELEMETRY_REQUEST</code><br><code>POST_ATTRIBUTES_REQUEST</code><br><code>ATTRIBUTES_UPDATED</code><br><code>ATTRIBUTES_DELETED</code><br><code>ALARM</code><br><br>Message will be routed via <b>Failure</b> route if node was not able to save edge event to database or unsupported originator type/message type arrived. In case successful storage edge event to database message will be routed via <b>Success</b> route.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodePushToEdgeConfig", icon="cloud_download", ruleChainTypes={RuleChainType.CORE})
public class TbMsgPushToEdgeNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgPushToEdgeNode.class);
    private TbMsgPushToEdgeNodeConfiguration config;
    private static final String SCOPE = "scope";
    private static final int DEFAULT_PAGE_SIZE = 1000;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgPushToEdgeNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgPushToEdgeNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if ("edge".equalsIgnoreCase(msg.getMetaData().getValue("source"))) {
            log.debug("Ignoring msg from the cloud, msg [{}]", (Object)msg);
            ctx.ack(msg);
            return;
        }
        if (this.isSupportedOriginator(msg.getOriginator().getEntityType())) {
            if (this.isSupportedMsgType(msg.getType())) {
                this.processMsg(ctx, msg);
            } else {
                log.debug("Unsupported msg type {}", (Object)msg.getType());
                ctx.tellFailure(msg, (Throwable)new RuntimeException("Unsupported msg type '" + msg.getType() + "'"));
            }
        } else {
            log.debug("Unsupported originator type {}", (Object)msg.getOriginator().getEntityType());
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Unsupported originator type '" + msg.getOriginator().getEntityType() + "'"));
        }
    }

    private void processMsg(TbContext ctx, TbMsg msg) {
        if (EntityType.EDGE.equals((Object)msg.getOriginator().getEntityType())) {
            EdgeEvent edgeEvent = this.buildEdgeEvent(msg, ctx);
            if (edgeEvent != null) {
                EdgeId edgeId = new EdgeId(msg.getOriginator().getId());
                this.notifyEdge(ctx, msg, edgeEvent, edgeId);
            }
        } else {
            PageData pageData;
            PageLink pageLink = new PageLink(1000);
            do {
                if ((pageData = ctx.getEdgeService().findRelatedEdgeIdsByEntityId(ctx.getTenantId(), msg.getOriginator(), pageLink)) == null || pageData.getData() == null || pageData.getData().isEmpty()) continue;
                for (EdgeId edgeId : pageData.getData()) {
                    EdgeEvent edgeEvent = this.buildEdgeEvent(msg, ctx);
                    if (edgeEvent == null) {
                        log.debug("Edge event type is null. Entity Type {}", (Object)msg.getOriginator().getEntityType());
                        ctx.tellFailure(msg, (Throwable)new RuntimeException("Edge event type is null. Entity Type '" + msg.getOriginator().getEntityType() + "'"));
                        continue;
                    }
                    this.notifyEdge(ctx, msg, edgeEvent, edgeId);
                }
                if (!pageData.hasNext()) continue;
                pageLink = pageLink.nextPageLink();
            } while (pageData != null && pageData.hasNext());
        }
    }

    private void notifyEdge(TbContext ctx, TbMsg msg, EdgeEvent edgeEvent, EdgeId edgeId) {
        edgeEvent.setEdgeId(edgeId);
        ctx.getEdgeEventService().save(edgeEvent);
        ctx.tellNext(msg, TbRelationTypes.SUCCESS);
        ctx.onEdgeEventUpdate(ctx.getTenantId(), edgeId);
    }

    private EdgeEvent buildEdgeEvent(TbMsg msg, TbContext ctx) {
        String msgType = msg.getType();
        if ("ALARM".equals(msgType)) {
            return this.buildEdgeEvent(ctx.getTenantId(), EdgeEventActionType.ADDED, this.getUUIDFromMsgData(msg), EdgeEventType.ALARM, null);
        }
        EdgeEventType edgeEventTypeByEntityType = EdgeUtils.getEdgeEventTypeByEntityType((EntityType)msg.getOriginator().getEntityType());
        if (edgeEventTypeByEntityType == null) {
            return null;
        }
        EdgeEventActionType actionType = this.getEdgeEventActionTypeByMsgType(msgType);
        HashMap<String, Object> entityBody = new HashMap<String, Object>();
        Map metadata = msg.getMetaData().getData();
        JsonNode dataJson = JacksonUtil.toJsonNode((String)msg.getData());
        switch (actionType) {
            case ATTRIBUTES_UPDATED: 
            case POST_ATTRIBUTES: {
                entityBody.put("kv", dataJson);
                entityBody.put(SCOPE, this.getScope(metadata));
                break;
            }
            case ATTRIBUTES_DELETED: {
                List keys = (List)JacksonUtil.convertValue((Object)dataJson.get("attributes"), (TypeReference)new TypeReference<List<String>>(){});
                entityBody.put("keys", keys);
                entityBody.put(SCOPE, this.getScope(metadata));
                break;
            }
            case TIMESERIES_UPDATED: {
                entityBody.put("data", dataJson);
                entityBody.put("ts", metadata.get("ts"));
            }
        }
        return this.buildEdgeEvent(ctx.getTenantId(), actionType, msg.getOriginator().getId(), edgeEventTypeByEntityType, JacksonUtil.valueToTree(entityBody));
    }

    private String getScope(Map<String, String> metadata) {
        String scope = metadata.get(SCOPE);
        if (StringUtils.isEmpty((String)scope)) {
            scope = this.config.getScope();
        }
        return scope;
    }

    private EdgeEvent buildEdgeEvent(TenantId tenantId, EdgeEventActionType edgeEventAction, UUID entityId, EdgeEventType edgeEventType, JsonNode entityBody) {
        EdgeEvent edgeEvent = new EdgeEvent();
        edgeEvent.setTenantId(tenantId);
        edgeEvent.setAction(edgeEventAction);
        edgeEvent.setEntityId(entityId);
        edgeEvent.setType(edgeEventType);
        edgeEvent.setBody(entityBody);
        return edgeEvent;
    }

    private UUID getUUIDFromMsgData(TbMsg msg) {
        JsonNode data = JacksonUtil.toJsonNode((String)msg.getData()).get("id");
        String id = (String)JacksonUtil.convertValue((Object)data.get("id"), String.class);
        return UUID.fromString(id);
    }

    private EdgeEventActionType getEdgeEventActionTypeByMsgType(String msgType) {
        EdgeEventActionType actionType = SessionMsgType.POST_TELEMETRY_REQUEST.name().equals(msgType) ? EdgeEventActionType.TIMESERIES_UPDATED : ("ATTRIBUTES_UPDATED".equals(msgType) ? EdgeEventActionType.ATTRIBUTES_UPDATED : (SessionMsgType.POST_ATTRIBUTES_REQUEST.name().equals(msgType) ? EdgeEventActionType.POST_ATTRIBUTES : EdgeEventActionType.ATTRIBUTES_DELETED));
        return actionType;
    }

    private boolean isSupportedOriginator(EntityType entityType) {
        switch (entityType) {
            case DEVICE: 
            case ASSET: 
            case ENTITY_VIEW: 
            case DASHBOARD: 
            case TENANT: 
            case CUSTOMER: 
            case EDGE: {
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedMsgType(String msgType) {
        return SessionMsgType.POST_TELEMETRY_REQUEST.name().equals(msgType) || SessionMsgType.POST_ATTRIBUTES_REQUEST.name().equals(msgType) || "ATTRIBUTES_UPDATED".equals(msgType) || "ATTRIBUTES_DELETED".equals(msgType) || "ALARM".equals(msgType);
    }

    public void destroy() {
    }
}

