/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.edge;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.edge.TbMsgPushToCloudNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="push to cloud", configClazz=TbMsgPushToCloudNodeConfiguration.class, nodeDescription="Pushes messages from edge to cloud", nodeDetails="Push messages from edge to cloud. This node used only on edge to push messages from edge to cloud. Once message arrived into this node it\u2019s going to be converted into cloud event and saved to the local database. Node doesn't push messages directly to cloud, but stores event(s) in the cloud queue. <br>Supports next originator types:<br><code>DEVICE</code><br><code>ASSET</code><br><code>ENTITY_VIEW</code><br><code>DASHBOARD</code><br><code>TENANT</code><br><code>CUSTOMER</code><br><code>EDGE</code><br><br>As well node supports next message types:<br><code>POST_TELEMETRY_REQUEST</code><br><code>POST_ATTRIBUTES_REQUEST</code><br><code>ATTRIBUTES_UPDATED</code><br><code>ATTRIBUTES_DELETED</code><br><code>ALARM</code><br><br>Message will be routed via <b>Failure</b> route if node was not able to save cloud event to database or unsupported originator type/message type arrived. In case successful storage cloud event to database message will be routed via <b>Success</b> route.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodePushToCloudConfig", icon="cloud_upload", ruleChainTypes={RuleChainType.EDGE})
public class TbMsgPushToCloudNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgPushToCloudNode.class);
    private TbMsgPushToCloudNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgPushToCloudNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgPushToCloudNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
    }

    public void destroy() {
    }
}

