/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.debug;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.TbStopWatch;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.debug.TbMsgGeneratorNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;

@RuleNode(type=ComponentType.ACTION, name="generator", configClazz=TbMsgGeneratorNodeConfiguration.class, nodeDescription="Periodically generates messages", nodeDetails="Generates messages with configurable period. Javascript function used for message generation.", inEnabled=false, uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeGeneratorConfig", icon="repeat")
public class TbMsgGeneratorNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgGeneratorNode.class);
    private static final String TB_MSG_GENERATOR_NODE_MSG = "TbMsgGeneratorNodeMsg";
    private TbMsgGeneratorNodeConfiguration config;
    private ScriptEngine jsEngine;
    private long delay;
    private long lastScheduledTs;
    private int currentMsgCount;
    private EntityId originatorId;
    private UUID nextTickId;
    private TbMsg prevMsg;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        log.trace("init generator with config {}", (Object)configuration);
        this.config = (TbMsgGeneratorNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgGeneratorNodeConfiguration.class);
        this.delay = TimeUnit.SECONDS.toMillis(this.config.getPeriodInSeconds());
        this.currentMsgCount = 0;
        this.originatorId = !StringUtils.isEmpty((Object)this.config.getOriginatorId()) ? EntityIdFactory.getByTypeAndUuid((EntityType)this.config.getOriginatorType(), (String)this.config.getOriginatorId()) : ctx.getSelfId();
        this.updateGeneratorState(ctx);
    }

    public void onPartitionChangeMsg(TbContext ctx, PartitionChangeMsg msg) {
        log.trace("onPartitionChangeMsg, PartitionChangeMsg {}, config {}", (Object)msg, (Object)this.config);
        this.updateGeneratorState(ctx);
    }

    private void updateGeneratorState(TbContext ctx) {
        log.trace("updateGeneratorState, config {}", (Object)this.config);
        if (ctx.isLocalEntity(this.originatorId)) {
            if (this.initialized.compareAndSet(false, true)) {
                this.jsEngine = ctx.createJsScriptEngine(this.config.getJsScript(), new String[]{"prevMsg", "prevMetadata", "prevMsgType"});
                this.scheduleTickMsg(ctx);
            }
        } else if (this.initialized.compareAndSet(true, false)) {
            this.destroy();
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        log.trace("onMsg, config {}, msg {}", (Object)this.config, (Object)msg);
        if (this.initialized.get() && msg.getType().equals(TB_MSG_GENERATOR_NODE_MSG) && msg.getId().equals(this.nextTickId)) {
            TbStopWatch sw = TbStopWatch.startNew();
            DonAsynchron.withCallback(this.generate(ctx, msg), m -> {
                log.trace("onMsg onSuccess callback, took {}ms, config {}, msg {}", new Object[]{sw.stopAndGetTotalTimeMillis(), this.config, msg});
                if (this.initialized.get() && (this.config.getMsgCount() == 0 || this.currentMsgCount < this.config.getMsgCount())) {
                    ctx.enqueueForTellNext(m, TbRelationTypes.SUCCESS);
                    this.scheduleTickMsg(ctx);
                    ++this.currentMsgCount;
                }
            }, t -> {
                log.warn("onMsg onFailure callback, took {}ms, config {}, msg {}, exception {}", new Object[]{sw.stopAndGetTotalTimeMillis(), this.config, msg, t});
                if (this.initialized.get() && (this.config.getMsgCount() == 0 || this.currentMsgCount < this.config.getMsgCount())) {
                    ctx.tellFailure(msg, t);
                    this.scheduleTickMsg(ctx);
                    ++this.currentMsgCount;
                }
            });
        }
    }

    private void scheduleTickMsg(TbContext ctx) {
        log.trace("scheduleTickMsg, config {}", (Object)this.config);
        long curTs = System.currentTimeMillis();
        if (this.lastScheduledTs == 0L) {
            this.lastScheduledTs = curTs;
        }
        this.lastScheduledTs += this.delay;
        long curDelay = Math.max(0L, this.lastScheduledTs - curTs);
        TbMsg tickMsg = ctx.newMsg("Main", TB_MSG_GENERATOR_NODE_MSG, (EntityId)ctx.getSelfId(), new TbMsgMetaData(), "");
        this.nextTickId = tickMsg.getId();
        ctx.tellSelf(tickMsg, curDelay);
    }

    private ListenableFuture<TbMsg> generate(TbContext ctx, TbMsg msg) {
        log.trace("generate, config {}", (Object)this.config);
        if (this.prevMsg == null) {
            this.prevMsg = ctx.newMsg("Main", "", this.originatorId, msg.getCustomerId(), new TbMsgMetaData(), "{}");
        }
        if (this.initialized.get()) {
            ctx.logJsEvalRequest();
            return Futures.transformAsync((ListenableFuture)this.jsEngine.executeGenerateAsync(this.prevMsg), generated -> {
                log.trace("generate process response, generated {}, config {}", generated, (Object)this.config);
                ctx.logJsEvalResponse();
                this.prevMsg = ctx.newMsg("Main", generated.getType(), this.originatorId, msg.getCustomerId(), generated.getMetaData(), generated.getData());
                return Futures.immediateFuture((Object)this.prevMsg);
            }, (Executor)MoreExecutors.directExecutor());
        }
        return Futures.immediateFuture((Object)this.prevMsg);
    }

    public void destroy() {
        log.trace("destroy, config {}", (Object)this.config);
        this.prevMsg = null;
        if (this.jsEngine != null) {
            this.jsEngine.destroy();
            this.jsEngine = null;
        }
    }
}

