/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbLogNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="log", configClazz=TbLogNodeConfiguration.class, nodeDescription="Log incoming messages using JS script for transformation Message into String", nodeDetails="Transform incoming Message with configured JS function to String and log final value into Thingsboard log file. Message payload can be accessed via <code>msg</code> property. For example <code>'temperature = ' + msg.temperature ;</code>. Message metadata can be accessed via <code>metadata</code> property. For example <code>'name = ' + metadata.customerName;</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeLogConfig", icon="menu")
public class TbLogNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbLogNode.class);
    private TbLogNodeConfiguration config;
    private ScriptEngine jsEngine;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbLogNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbLogNodeConfiguration.class);
        this.jsEngine = ctx.createJsScriptEngine(this.config.getJsScript(), new String[0]);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) {
        ctx.logJsEvalRequest();
        Futures.addCallback((ListenableFuture)this.jsEngine.executeToStringAsync(msg), (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(@Nullable String result) {
                ctx.logJsEvalResponse();
                log.info(result);
                ctx.tellSuccess(msg);
            }

            public void onFailure(Throwable t) {
                ctx.logJsEvalResponse();
                ctx.tellFailure(msg, t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void destroy() {
        if (this.jsEngine != null) {
            this.jsEngine.destroy();
        }
    }
}

