/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractRelationActionNode;
import org.thingsboard.rule.engine.action.TbDeleteRelationNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.util.EntityContainer;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="delete relation", configClazz=TbDeleteRelationNodeConfiguration.class, nodeDescription="Finds target Entity by entity name pattern and then delete a relation to Originator Entity by type and direction if 'Delete single entity' is set to true, otherwise rule node will delete all relations to the originator of the message by type and direction.", nodeDetails="If the relation(s) successfully deleted -  Message send via <b>Success</b> chain, otherwise <b>Failure</b> chain will be used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeDeleteRelationConfig", icon="remove_circle")
public class TbDeleteRelationNode
extends TbAbstractRelationActionNode<TbDeleteRelationNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbDeleteRelationNode.class);

    @Override
    protected TbDeleteRelationNodeConfiguration loadEntityNodeActionConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbDeleteRelationNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDeleteRelationNodeConfiguration.class);
    }

    @Override
    protected boolean createEntityIfNotExists() {
        return false;
    }

    @Override
    protected ListenableFuture<TbAbstractRelationActionNode.RelationContainer> processEntityRelationAction(TbContext ctx, TbMsg msg, String relationType) {
        return this.getRelationContainerListenableFuture(ctx, msg, relationType);
    }

    @Override
    protected ListenableFuture<TbAbstractRelationActionNode.RelationContainer> doProcessEntityRelationAction(TbContext ctx, TbMsg msg, EntityContainer entityContainer, String relationType) {
        return Futures.transform(this.processSingle(ctx, msg, entityContainer, relationType), result -> new TbAbstractRelationActionNode.RelationContainer(msg, (boolean)result), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<TbAbstractRelationActionNode.RelationContainer> getRelationContainerListenableFuture(TbContext ctx, TbMsg msg, String relationType) {
        if (((TbDeleteRelationNodeConfiguration)this.config).isDeleteForSingleEntity()) {
            return Futures.transformAsync(this.getEntity(ctx, msg), entityContainer -> this.doProcessEntityRelationAction(ctx, msg, (EntityContainer)entityContainer, relationType), (Executor)ctx.getDbCallbackExecutor());
        }
        return Futures.transform(this.processList(ctx, msg), result -> new TbAbstractRelationActionNode.RelationContainer(msg, (boolean)result), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processList(TbContext ctx, TbMsg msg) {
        return Futures.transformAsync(this.processListSearchDirection(ctx, msg), entityRelations -> {
            if (entityRelations.isEmpty()) {
                return Futures.immediateFuture((Object)true);
            }
            ArrayList<ListenableFuture> listenableFutureList = new ArrayList<ListenableFuture>();
            for (EntityRelation entityRelation : entityRelations) {
                listenableFutureList.add(ctx.getRelationService().deleteRelationAsync(ctx.getTenantId(), entityRelation));
            }
            return Futures.transformAsync((ListenableFuture)Futures.allAsList(listenableFutureList), booleans -> {
                for (Boolean bool : booleans) {
                    if (bool.booleanValue()) continue;
                    return Futures.immediateFuture((Object)false);
                }
                return Futures.immediateFuture((Object)true);
            }, (Executor)ctx.getDbCallbackExecutor());
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processSingle(TbContext ctx, TbMsg msg, EntityContainer entityContainer, String relationType) {
        TbAbstractRelationActionNode.SearchDirectionIds sdId = this.processSingleSearchDirection(msg, entityContainer);
        return Futures.transformAsync((ListenableFuture)ctx.getRelationService().checkRelation(ctx.getTenantId(), sdId.getFromId(), sdId.getToId(), relationType, RelationTypeGroup.COMMON), result -> {
            if (result.booleanValue()) {
                return this.processSingleDeleteRelation(ctx, sdId, relationType);
            }
            return Futures.immediateFuture((Object)true);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processSingleDeleteRelation(TbContext ctx, TbAbstractRelationActionNode.SearchDirectionIds sdId, String relationType) {
        return ctx.getRelationService().deleteRelationAsync(ctx.getTenantId(), sdId.getFromId(), sdId.getToId(), relationType, RelationTypeGroup.COMMON);
    }
}

