/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import java.util.Collections;
import java.util.List;
import org.thingsboard.rule.engine.action.TbAbstractAlarmNodeConfiguration;
import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;

public class TbCreateAlarmNodeConfiguration
extends TbAbstractAlarmNodeConfiguration
implements NodeConfiguration<TbCreateAlarmNodeConfiguration> {
    private String severity;
    private boolean propagate;
    private boolean propagateToOwner;
    private boolean propagateToTenant;
    private boolean useMessageAlarmData;
    private boolean dynamicSeverity;
    private List<String> relationTypes;

    public TbCreateAlarmNodeConfiguration defaultConfiguration() {
        TbCreateAlarmNodeConfiguration configuration = new TbCreateAlarmNodeConfiguration();
        configuration.setAlarmDetailsBuildJs("var details = {};\nif (metadata.prevAlarmDetails) {\n    details = JSON.parse(metadata.prevAlarmDetails);\n    //remove prevAlarmDetails from metadata\n    delete metadata.prevAlarmDetails;\n    //now metadata is the same as it comes IN this rule node\n}\n\n\nreturn details;");
        configuration.setAlarmType("General Alarm");
        configuration.setSeverity(AlarmSeverity.CRITICAL.name());
        configuration.setPropagate(false);
        configuration.setPropagateToOwner(false);
        configuration.setPropagateToTenant(false);
        configuration.setUseMessageAlarmData(false);
        configuration.setRelationTypes(Collections.emptyList());
        configuration.setDynamicSeverity(false);
        return configuration;
    }

    public String getSeverity() {
        return this.severity;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    public boolean isPropagateToOwner() {
        return this.propagateToOwner;
    }

    public boolean isPropagateToTenant() {
        return this.propagateToTenant;
    }

    public boolean isUseMessageAlarmData() {
        return this.useMessageAlarmData;
    }

    public boolean isDynamicSeverity() {
        return this.dynamicSeverity;
    }

    public List<String> getRelationTypes() {
        return this.relationTypes;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public void setPropagateToOwner(boolean propagateToOwner) {
        this.propagateToOwner = propagateToOwner;
    }

    public void setPropagateToTenant(boolean propagateToTenant) {
        this.propagateToTenant = propagateToTenant;
    }

    public void setUseMessageAlarmData(boolean useMessageAlarmData) {
        this.useMessageAlarmData = useMessageAlarmData;
    }

    public void setDynamicSeverity(boolean dynamicSeverity) {
        this.dynamicSeverity = dynamicSeverity;
    }

    public void setRelationTypes(List<String> relationTypes) {
        this.relationTypes = relationTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCreateAlarmNodeConfiguration)) {
            return false;
        }
        TbCreateAlarmNodeConfiguration other = (TbCreateAlarmNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPropagate() != other.isPropagate()) {
            return false;
        }
        if (this.isPropagateToOwner() != other.isPropagateToOwner()) {
            return false;
        }
        if (this.isPropagateToTenant() != other.isPropagateToTenant()) {
            return false;
        }
        if (this.isUseMessageAlarmData() != other.isUseMessageAlarmData()) {
            return false;
        }
        if (this.isDynamicSeverity() != other.isDynamicSeverity()) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        List<String> this$relationTypes = this.getRelationTypes();
        List<String> other$relationTypes = other.getRelationTypes();
        return !(this$relationTypes == null ? other$relationTypes != null : !((Object)this$relationTypes).equals(other$relationTypes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbCreateAlarmNodeConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwner() ? 79 : 97);
        result = result * 59 + (this.isPropagateToTenant() ? 79 : 97);
        result = result * 59 + (this.isUseMessageAlarmData() ? 79 : 97);
        result = result * 59 + (this.isDynamicSeverity() ? 79 : 97);
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        List<String> $relationTypes = this.getRelationTypes();
        result = result * 59 + ($relationTypes == null ? 43 : ((Object)$relationTypes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TbCreateAlarmNodeConfiguration(severity=" + this.getSeverity() + ", propagate=" + this.isPropagate() + ", propagateToOwner=" + this.isPropagateToOwner() + ", propagateToTenant=" + this.isPropagateToTenant() + ", useMessageAlarmData=" + this.isUseMessageAlarmData() + ", dynamicSeverity=" + this.isDynamicSeverity() + ", relationTypes=" + this.getRelationTypes() + ")";
    }
}

