/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.action.TbAbstractRelationActionNodeConfiguration;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.util.EntityContainer;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.user.UserService;

public abstract class TbAbstractRelationActionNode<C extends TbAbstractRelationActionNodeConfiguration>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractRelationActionNode.class);
    protected C config;
    private LoadingCache<EntityKey, EntityContainer> entityIdCache;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadEntityNodeActionConfig(configuration);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (((TbAbstractRelationActionNodeConfiguration)this.config).getEntityCacheExpiration() > 0L) {
            cacheBuilder.expireAfterWrite(((TbAbstractRelationActionNodeConfiguration)this.config).getEntityCacheExpiration(), TimeUnit.SECONDS);
        }
        this.entityIdCache = cacheBuilder.build((CacheLoader)new EntityCacheLoader(ctx, this.createEntityIfNotExists()));
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        String relationType = this.processPattern(msg, ((TbAbstractRelationActionNodeConfiguration)this.config).getRelationType());
        DonAsynchron.withCallback(this.processEntityRelationAction(ctx, msg, relationType), filterResult -> ctx.tellNext(filterResult.getMsg(), filterResult.isResult() ? TbRelationTypes.SUCCESS : TbRelationTypes.FAILURE), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    public void destroy() {
    }

    protected ListenableFuture<RelationContainer> processEntityRelationAction(TbContext ctx, TbMsg msg, String relationType) {
        return Futures.transformAsync(this.getEntity(ctx, msg), entityContainer -> this.doProcessEntityRelationAction(ctx, msg, (EntityContainer)entityContainer, relationType), (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract boolean createEntityIfNotExists();

    protected abstract ListenableFuture<RelationContainer> doProcessEntityRelationAction(TbContext var1, TbMsg var2, EntityContainer var3, String var4);

    protected abstract C loadEntityNodeActionConfig(TbNodeConfiguration var1) throws TbNodeException;

    protected ListenableFuture<EntityContainer> getEntity(TbContext ctx, TbMsg msg) {
        String entityName = this.processPattern(msg, ((TbAbstractRelationActionNodeConfiguration)this.config).getEntityNamePattern());
        String type = ((TbAbstractRelationActionNodeConfiguration)this.config).getEntityTypePattern() != null ? this.processPattern(msg, ((TbAbstractRelationActionNodeConfiguration)this.config).getEntityTypePattern()) : null;
        EntityType entityType = EntityType.valueOf((String)((TbAbstractRelationActionNodeConfiguration)this.config).getEntityType());
        EntityKey key = new EntityKey(entityName, type, entityType);
        return ctx.getDbCallbackExecutor().executeAsync(() -> {
            EntityContainer entityContainer = (EntityContainer)this.entityIdCache.get((Object)key);
            if (entityContainer.getEntityId() == null) {
                throw new RuntimeException("No entity found with type '" + key.getEntityType() + "' and name '" + key.getEntityName() + "'.");
            }
            return entityContainer;
        });
    }

    protected SearchDirectionIds processSingleSearchDirection(TbMsg msg, EntityContainer entityContainer) {
        SearchDirectionIds searchDirectionIds = new SearchDirectionIds();
        if (EntitySearchDirection.FROM.name().equals(((TbAbstractRelationActionNodeConfiguration)this.config).getDirection())) {
            searchDirectionIds.setFromId(EntityIdFactory.getByTypeAndId((String)entityContainer.getEntityType().name(), (String)entityContainer.getEntityId().toString()));
            searchDirectionIds.setToId(msg.getOriginator());
            searchDirectionIds.setOriginatorDirectionFrom(false);
        } else {
            searchDirectionIds.setToId(EntityIdFactory.getByTypeAndId((String)entityContainer.getEntityType().name(), (String)entityContainer.getEntityId().toString()));
            searchDirectionIds.setFromId(msg.getOriginator());
            searchDirectionIds.setOriginatorDirectionFrom(true);
        }
        return searchDirectionIds;
    }

    protected ListenableFuture<List<EntityRelation>> processListSearchDirection(TbContext ctx, TbMsg msg) {
        if (EntitySearchDirection.FROM.name().equals(((TbAbstractRelationActionNodeConfiguration)this.config).getDirection())) {
            return ctx.getRelationService().findByToAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), this.processPattern(msg, ((TbAbstractRelationActionNodeConfiguration)this.config).getRelationType()), RelationTypeGroup.COMMON);
        }
        return ctx.getRelationService().findByFromAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), this.processPattern(msg, ((TbAbstractRelationActionNodeConfiguration)this.config).getRelationType()), RelationTypeGroup.COMMON);
    }

    protected String processPattern(TbMsg msg, String pattern) {
        return TbNodeUtils.processPattern((String)pattern, (TbMsg)msg);
    }

    protected static class RelationContainer {
        private TbMsg msg;
        private boolean result;

        public TbMsg getMsg() {
            return this.msg;
        }

        public boolean isResult() {
            return this.result;
        }

        public void setMsg(TbMsg msg) {
            this.msg = msg;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationContainer)) {
                return false;
            }
            RelationContainer other = (RelationContainer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isResult() != other.isResult()) {
                return false;
            }
            TbMsg this$msg = this.getMsg();
            TbMsg other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RelationContainer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isResult() ? 79 : 97);
            TbMsg $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        public String toString() {
            return "TbAbstractRelationActionNode.RelationContainer(msg=" + this.getMsg() + ", result=" + this.isResult() + ")";
        }

        public RelationContainer() {
        }

        @ConstructorProperties(value={"msg", "result"})
        public RelationContainer(TbMsg msg, boolean result) {
            this.msg = msg;
            this.result = result;
        }
    }

    private static class EntityCacheLoader
    extends CacheLoader<EntityKey, EntityContainer> {
        private final TbContext ctx;
        private final boolean createIfNotExists;

        private EntityCacheLoader(TbContext ctx, boolean createIfNotExists) {
            this.ctx = ctx;
            this.createIfNotExists = createIfNotExists;
        }

        public EntityContainer load(EntityKey key) {
            return this.loadEntity(key);
        }

        private EntityContainer loadEntity(EntityKey entitykey) {
            EntityType type = entitykey.getEntityType();
            EntityContainer targetEntity = new EntityContainer();
            targetEntity.setEntityType(type);
            switch (type) {
                case DEVICE: {
                    DeviceService deviceService = this.ctx.getDeviceService();
                    Device device = deviceService.findDeviceByTenantIdAndName(this.ctx.getTenantId(), entitykey.getEntityName());
                    if (device != null) {
                        targetEntity.setEntityId((EntityId)device.getId());
                        break;
                    }
                    if (!this.createIfNotExists) break;
                    Device newDevice = new Device();
                    newDevice.setName(entitykey.getEntityName());
                    newDevice.setType(entitykey.getType());
                    newDevice.setTenantId(this.ctx.getTenantId());
                    Device savedDevice = deviceService.saveDevice(newDevice);
                    this.ctx.getClusterService().onDeviceUpdated(savedDevice, null);
                    this.ctx.enqueue(this.ctx.deviceCreatedMsg(savedDevice, this.ctx.getSelfId()), () -> log.trace("Pushed Device Created message: {}", (Object)savedDevice), throwable -> log.warn("Failed to push Device Created message: {}", (Object)savedDevice, throwable));
                    targetEntity.setEntityId((EntityId)savedDevice.getId());
                    break;
                }
                case ASSET: {
                    AssetService assetService = this.ctx.getAssetService();
                    Asset asset = assetService.findAssetByTenantIdAndName(this.ctx.getTenantId(), entitykey.getEntityName());
                    if (asset != null) {
                        targetEntity.setEntityId((EntityId)asset.getId());
                        break;
                    }
                    if (!this.createIfNotExists) break;
                    Asset newAsset = new Asset();
                    newAsset.setName(entitykey.getEntityName());
                    newAsset.setType(entitykey.getType());
                    newAsset.setTenantId(this.ctx.getTenantId());
                    Asset savedAsset = assetService.saveAsset(newAsset);
                    this.ctx.enqueue(this.ctx.assetCreatedMsg(savedAsset, this.ctx.getSelfId()), () -> log.trace("Pushed Asset Created message: {}", (Object)savedAsset), throwable -> log.warn("Failed to push Asset Created message: {}", (Object)savedAsset, throwable));
                    targetEntity.setEntityId((EntityId)savedAsset.getId());
                    break;
                }
                case CUSTOMER: {
                    CustomerService customerService = this.ctx.getCustomerService();
                    Optional customerOptional = customerService.findCustomerByTenantIdAndTitle(this.ctx.getTenantId(), entitykey.getEntityName());
                    if (customerOptional.isPresent()) {
                        targetEntity.setEntityId((EntityId)((Customer)customerOptional.get()).getId());
                        break;
                    }
                    if (!this.createIfNotExists) break;
                    Customer newCustomer = new Customer();
                    newCustomer.setTitle(entitykey.getEntityName());
                    newCustomer.setTenantId(this.ctx.getTenantId());
                    Customer savedCustomer = customerService.saveCustomer(newCustomer);
                    this.ctx.enqueue(this.ctx.customerCreatedMsg(savedCustomer, this.ctx.getSelfId()), () -> log.trace("Pushed Customer Created message: {}", (Object)savedCustomer), throwable -> log.warn("Failed to push Customer Created message: {}", (Object)savedCustomer, throwable));
                    targetEntity.setEntityId((EntityId)savedCustomer.getId());
                    break;
                }
                case TENANT: {
                    targetEntity.setEntityId((EntityId)this.ctx.getTenantId());
                    break;
                }
                case ENTITY_VIEW: {
                    EntityViewService entityViewService = this.ctx.getEntityViewService();
                    EntityView entityView = entityViewService.findEntityViewByTenantIdAndName(this.ctx.getTenantId(), entitykey.getEntityName());
                    if (entityView == null) break;
                    targetEntity.setEntityId((EntityId)entityView.getId());
                    break;
                }
                case EDGE: {
                    EdgeService edgeService = this.ctx.getEdgeService();
                    Edge edge = edgeService.findEdgeByTenantIdAndName(this.ctx.getTenantId(), entitykey.getEntityName());
                    if (edge == null) break;
                    targetEntity.setEntityId((EntityId)edge.getId());
                    break;
                }
                case DASHBOARD: {
                    DashboardService dashboardService = this.ctx.getDashboardService();
                    PageData dashboardInfoTextPageData = dashboardService.findDashboardsByTenantId(this.ctx.getTenantId(), new PageLink(200, 0, entitykey.getEntityName()));
                    for (DashboardInfo dashboardInfo : dashboardInfoTextPageData.getData()) {
                        if (!dashboardInfo.getTitle().equals(entitykey.getEntityName())) continue;
                        targetEntity.setEntityId((EntityId)dashboardInfo.getId());
                    }
                    break;
                }
                case USER: {
                    UserService userService = this.ctx.getUserService();
                    User user = userService.findUserByEmail(this.ctx.getTenantId(), entitykey.getEntityName());
                    if (user == null) break;
                    targetEntity.setEntityId((EntityId)user.getId());
                    break;
                }
                default: {
                    return targetEntity;
                }
            }
            return targetEntity;
        }
    }

    protected static class SearchDirectionIds {
        private EntityId fromId;
        private EntityId toId;
        private boolean originatorDirectionFrom;

        public EntityId getFromId() {
            return this.fromId;
        }

        public EntityId getToId() {
            return this.toId;
        }

        public boolean isOriginatorDirectionFrom() {
            return this.originatorDirectionFrom;
        }

        public void setFromId(EntityId fromId) {
            this.fromId = fromId;
        }

        public void setToId(EntityId toId) {
            this.toId = toId;
        }

        public void setOriginatorDirectionFrom(boolean originatorDirectionFrom) {
            this.originatorDirectionFrom = originatorDirectionFrom;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchDirectionIds)) {
                return false;
            }
            SearchDirectionIds other = (SearchDirectionIds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOriginatorDirectionFrom() != other.isOriginatorDirectionFrom()) {
                return false;
            }
            EntityId this$fromId = this.getFromId();
            EntityId other$fromId = other.getFromId();
            if (this$fromId == null ? other$fromId != null : !this$fromId.equals(other$fromId)) {
                return false;
            }
            EntityId this$toId = this.getToId();
            EntityId other$toId = other.getToId();
            return !(this$toId == null ? other$toId != null : !this$toId.equals(other$toId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchDirectionIds;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOriginatorDirectionFrom() ? 79 : 97);
            EntityId $fromId = this.getFromId();
            result = result * 59 + ($fromId == null ? 43 : $fromId.hashCode());
            EntityId $toId = this.getToId();
            result = result * 59 + ($toId == null ? 43 : $toId.hashCode());
            return result;
        }

        public String toString() {
            return "TbAbstractRelationActionNode.SearchDirectionIds(fromId=" + this.getFromId() + ", toId=" + this.getToId() + ", originatorDirectionFrom=" + this.isOriginatorDirectionFrom() + ")";
        }
    }

    private static class EntityKey {
        private String entityName;
        private String type;
        private EntityType entityType;

        public String getEntityName() {
            return this.entityName;
        }

        public String getType() {
            return this.type;
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setEntityType(EntityType entityType) {
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityKey)) {
                return false;
            }
            EntityKey other = (EntityKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$entityName = this.getEntityName();
            String other$entityName = other.getEntityName();
            if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            EntityType this$entityType = this.getEntityType();
            EntityType other$entityType = other.getEntityType();
            return !(this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntityKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entityName = this.getEntityName();
            result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            EntityType $entityType = this.getEntityType();
            result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
            return result;
        }

        public String toString() {
            return "TbAbstractRelationActionNode.EntityKey(entityName=" + this.getEntityName() + ", type=" + this.getType() + ", entityType=" + this.getEntityType() + ")";
        }

        @ConstructorProperties(value={"entityName", "type", "entityType"})
        public EntityKey(String entityName, String type, EntityType entityType) {
            this.entityName = entityName;
            this.type = type;
            this.entityType = entityType;
        }
    }
}

