/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.data.RelationsQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.dao.relation.RelationService;

public class EntitiesRelatedEntityIdAsyncLoader {
    public static ListenableFuture<EntityId> findEntityAsync(TbContext ctx, EntityId originator, RelationsQuery relationsQuery) {
        RelationService relationService = ctx.getRelationService();
        EntityRelationsQuery query = EntitiesRelatedEntityIdAsyncLoader.buildQuery(originator, relationsQuery);
        ListenableFuture asyncRelation = relationService.findByQuery(ctx.getTenantId(), query);
        if (relationsQuery.getDirection() == EntitySearchDirection.FROM) {
            return Futures.transformAsync((ListenableFuture)asyncRelation, r -> CollectionUtils.isNotEmpty((Collection)r) ? Futures.immediateFuture((Object)((EntityRelation)r.get(0)).getTo()) : Futures.immediateFuture(null), (Executor)MoreExecutors.directExecutor());
        }
        if (relationsQuery.getDirection() == EntitySearchDirection.TO) {
            return Futures.transformAsync((ListenableFuture)asyncRelation, r -> CollectionUtils.isNotEmpty((Collection)r) ? Futures.immediateFuture((Object)((EntityRelation)r.get(0)).getFrom()) : Futures.immediateFuture(null), (Executor)MoreExecutors.directExecutor());
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unknown direction"));
    }

    public static ListenableFuture<List<EntityId>> findEntitiesAsync(TbContext ctx, EntityId originator, RelationsQuery relationsQuery) {
        return EntitiesRelatedEntityIdAsyncLoader.findEntitiesAsync(ctx, originator, relationsQuery, entityId -> true);
    }

    public static ListenableFuture<List<EntityId>> findEntitiesAsync(TbContext ctx, EntityId originator, RelationsQuery relationsQuery, Predicate<EntityId> entityFilter) {
        Function<EntityRelation, EntityId> mapFunction;
        RelationService relationService = ctx.getRelationService();
        EntityRelationsQuery query = EntitiesRelatedEntityIdAsyncLoader.buildQuery(originator, relationsQuery);
        ListenableFuture asyncRelation = relationService.findByQuery(ctx.getTenantId(), query);
        if (relationsQuery.getDirection() == EntitySearchDirection.FROM) {
            mapFunction = EntityRelation::getTo;
        } else if (relationsQuery.getDirection() == EntitySearchDirection.TO) {
            mapFunction = EntityRelation::getFrom;
        } else {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unknown direction"));
        }
        return Futures.transformAsync((ListenableFuture)asyncRelation, r -> CollectionUtils.isNotEmpty((Collection)r) ? Futures.immediateFuture(r.stream().map(mapFunction).filter(entityFilter).collect(Collectors.toList())) : Futures.immediateFuture(Collections.emptyList()), (Executor)MoreExecutors.directExecutor());
    }

    private static EntityRelationsQuery buildQuery(EntityId originator, RelationsQuery relationsQuery) {
        EntityRelationsQuery query = new EntityRelationsQuery();
        RelationsSearchParameters parameters = new RelationsSearchParameters(originator, relationsQuery.getDirection(), relationsQuery.getMaxLevel(), relationsQuery.isFetchLastLevelOnly());
        query.setParameters(parameters);
        query.setFilters(relationsQuery.getFilters());
        return query;
    }
}

