/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractDuplicateMsgToOriginatorsNode;
import org.thingsboard.rule.engine.transform.TbDuplicateMsgToRelatedNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.TRANSFORMATION, name="duplicate to related", configClazz=TbDuplicateMsgToRelatedNodeConfiguration.class, nodeDescription="Duplicates message to related entities fetched by relation query", nodeDetails="Related Entities found using configured relation direction and Relation Type. For each found related entity new message is created with related entity as originator and message parameters copied from original message.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeDuplicateToRelatedConfig", icon="call_split")
public class TbDuplicateMsgToRelatedNode
extends TbAbstractDuplicateMsgToOriginatorsNode {
    private static final Logger log = LoggerFactory.getLogger(TbDuplicateMsgToRelatedNode.class);
    private TbDuplicateMsgToRelatedNodeConfiguration config;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDuplicateMsgToRelatedNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDuplicateMsgToRelatedNodeConfiguration.class);
        this.validateConfig(this.config);
        this.setConfig(this.config);
    }

    @Override
    protected ListenableFuture<List<EntityId>> getNewOriginators(TbContext ctx, EntityId original) {
        return EntitiesRelatedEntityIdAsyncLoader.findEntitiesAsync(ctx, original, this.config.getRelationsQuery());
    }

    private void validateConfig(TbDuplicateMsgToRelatedNodeConfiguration conf) {
        if (conf.getRelationsQuery() == null) {
            log.error("TbDuplicateMsgToRelatedNode configuration should have relations query");
            throw new IllegalArgumentException("Wrong configuration for TbDuplicateMsgToRelatedNode: relation query is missing.");
        }
    }

    public void destroy() {
    }
}

