/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractDuplicateMsgToOriginatorsNode;
import org.thingsboard.rule.engine.transform.TbDuplicateMsgToGroupNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.TRANSFORMATION, name="duplicate to specific group", configClazz=TbDuplicateMsgToGroupNodeConfiguration.class, nodeDescription="Duplicates message to all entities belonging to specific Entity Group", nodeDetails="Entities are fetched from Entity Group detected according to the configuration. Entity Group can be specified directly or can be message originator entity itself. For each entity from group new message is created with entity as originator and message parameters copied from original message.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeDuplicateToGroupConfig", icon="call_split")
public class TbDuplicateMsgToGroupNode
extends TbAbstractDuplicateMsgToOriginatorsNode {
    private static final Logger log = LoggerFactory.getLogger(TbDuplicateMsgToGroupNode.class);
    private TbDuplicateMsgToGroupNodeConfiguration config;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDuplicateMsgToGroupNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDuplicateMsgToGroupNodeConfiguration.class);
        this.validateConfig(this.config);
        this.setConfig(this.config);
    }

    @Override
    protected ListenableFuture<List<EntityId>> getNewOriginators(TbContext ctx, EntityId original) {
        return ctx.getPeContext().getEntityGroupService().findAllEntityIds(ctx.getTenantId(), this.detectTargetEntityGroupId(original), new PageLink(Integer.MAX_VALUE));
    }

    private EntityGroupId detectTargetEntityGroupId(EntityId original) {
        if (this.config.isEntityGroupIsMessageOriginator()) {
            if (original.getEntityType() == EntityType.ENTITY_GROUP) {
                return new EntityGroupId(original.getId());
            }
            throw new RuntimeException("Message originator is not an entity group!");
        }
        return this.config.getEntityGroupId();
    }

    private void validateConfig(TbDuplicateMsgToGroupNodeConfiguration conf) {
        if (!conf.isEntityGroupIsMessageOriginator() && (conf.getEntityGroupId() == null || conf.getEntityGroupId().isNullUid())) {
            log.error("TbDuplicateMsgToGroupNode configuration should have valid Entity Group Id");
            throw new IllegalArgumentException("Wrong configuration for TbDuplicateMsgToGroupNode: Entity Group Id is missing.");
        }
    }

    public void destroy() {
    }
}

