/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractDuplicateMsgToOriginatorsNode;
import org.thingsboard.rule.engine.transform.TbDuplicateMsgToGroupByNameNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.TRANSFORMATION, name="duplicate to group by group name", configClazz=TbDuplicateMsgToGroupByNameNodeConfiguration.class, nodeDescription="Duplicates message to all entities belonging to resolved Entity Group", nodeDetails="Entities are fetched from Entity Group detected according to the configuration. Entity Group is dynamically resolved based on it's name and type.By default, rule node attempts to find the group by name that belongs to the same customer which owns the device (or other message originator). If no such group on the customer level, rule node will search for parent customer level and finally for the tenant level. You may configure rule node to search only tenant level entity groups.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeDuplicateToGroupByNameConfig", icon="call_split")
public class TbDuplicateMsgToGroupByNameNode
extends TbAbstractDuplicateMsgToOriginatorsNode {
    private static final Logger log = LoggerFactory.getLogger(TbDuplicateMsgToGroupByNameNode.class);
    private TbDuplicateMsgToGroupByNameNodeConfiguration config;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDuplicateMsgToGroupByNameNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDuplicateMsgToGroupByNameNodeConfiguration.class);
        this.validateConfig(this.config);
        this.setConfig(this.config);
    }

    @Override
    protected ListenableFuture<List<EntityId>> getNewOriginators(TbContext ctx, EntityId original) {
        try {
            return ctx.getPeContext().getEntityGroupService().findAllEntityIds(ctx.getTenantId(), this.detectTargetEntityGroupId(ctx, original), new PageLink(Integer.MAX_VALUE));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private EntityGroupId detectTargetEntityGroupId(TbContext ctx, EntityId originator) throws ExecutionException, InterruptedException {
        Object ownerId = this.config.isSearchEntityGroupForTenantOnly() ? ctx.getTenantId() : ctx.getPeContext().getOwner(ctx.getTenantId(), originator);
        return this.tryFindGroupByOwnerId(ctx, (EntityId)ownerId);
    }

    private EntityGroupId tryFindGroupByOwnerId(TbContext ctx, EntityId ownerId) throws ExecutionException, InterruptedException {
        EntityGroupId entityGroupId = ((Optional)ctx.getPeContext().getEntityGroupService().findEntityGroupByTypeAndName(ctx.getTenantId(), ownerId, this.config.getGroupType(), this.config.getGroupName()).get()).map(IdBased::getId).orElse(null);
        if (entityGroupId != null) {
            return entityGroupId;
        }
        if (!EntityType.TENANT.equals((Object)ownerId.getEntityType())) {
            return this.tryFindGroupByOwnerId(ctx, ctx.getPeContext().getOwner(ctx.getTenantId(), ownerId));
        }
        throw new RuntimeException("Can't find group with type: " + this.config.getGroupType() + " name: " + this.config.getGroupName() + "!");
    }

    private void validateConfig(TbDuplicateMsgToGroupByNameNodeConfiguration conf) {
        if (Resource.groupResourceFromGroupType((EntityType)conf.getGroupType()) == null) {
            throw new IllegalArgumentException("Wrong configuration. Specified Entity Type is not a group entity.");
        }
    }

    public void destroy() {
    }
}

