/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.transform.TbAbstractDuplicateMsgNode;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class TbAbstractDuplicateMsgToOriginatorsNode
extends TbAbstractDuplicateMsgNode {
    @Override
    protected ListenableFuture<List<TbMsg>> duplicate(TbContext ctx, TbMsg msg) {
        ListenableFuture<List<EntityId>> newOriginators = this.getNewOriginators(ctx, msg.getOriginator());
        return Futures.transform(newOriginators, entityIds -> {
            if (entityIds == null || entityIds.isEmpty()) {
                return null;
            }
            ArrayList<TbMsg> messages = new ArrayList<TbMsg>();
            if (entityIds.size() == 1) {
                messages.add(ctx.transformMsg(msg, msg.getType(), (EntityId)entityIds.get(0), msg.getMetaData(), msg.getData()));
            } else {
                for (EntityId entityId : entityIds) {
                    messages.add(ctx.newMsg(msg.getQueueName(), msg.getType(), entityId, msg.getMetaData(), msg.getData()));
                }
            }
            return messages;
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract ListenableFuture<List<EntityId>> getNewOriginators(TbContext var1, EntityId var2);
}

