/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbDuplicateMsgNodeConfiguration;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class TbAbstractDuplicateMsgNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractDuplicateMsgNode.class);
    private TbDuplicateMsgNodeConfiguration config;

    public void init(TbContext context, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDuplicateMsgNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDuplicateMsgNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        DonAsynchron.withCallback(this.duplicate(ctx, msg), messages -> {
            if (messages != null && !messages.isEmpty()) {
                if (messages.size() == 1) {
                    ctx.tellNext((TbMsg)messages.get(0), TbRelationTypes.SUCCESS);
                } else {
                    ctx.getPeContext().ack(msg);
                    for (TbMsg newMsg : messages) {
                        ctx.tellNext(newMsg, TbRelationTypes.SUCCESS);
                    }
                }
            } else {
                ctx.tellNext(msg, TbRelationTypes.FAILURE);
            }
        }, t -> ctx.tellFailure(msg, t));
    }

    protected abstract ListenableFuture<List<TbMsg>> duplicate(TbContext var1, TbMsg var2);

    public void setConfig(TbDuplicateMsgNodeConfiguration config) {
        this.config = config;
    }
}

