/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.rest;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.rest.TbSendRestApiCallReplyNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="rest call reply", configClazz=TbSendRestApiCallReplyNodeConfiguration.class, nodeDescription="Sends reply to REST API call to rule engine", nodeDetails="Expects messages with any message type. Forwards incoming message as a reply to REST API call sent to rule engine.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeSendRestApiCallReplyConfig", icon="call_merge")
public class TbSendRestApiCallReplyNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbSendRestApiCallReplyNode.class);
    private TbSendRestApiCallReplyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbSendRestApiCallReplyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSendRestApiCallReplyNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        String serviceIdStr = msg.getMetaData().getValue(this.config.getServiceIdMetaDataAttribute());
        String requestIdStr = msg.getMetaData().getValue(this.config.getRequestIdMetaDataAttribute());
        if (StringUtils.isEmpty((Object)requestIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Request id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((Object)msg.getData())) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Request body is empty!"));
        } else {
            ctx.getRpcService().sendRestApiCallReply(serviceIdStr, UUID.fromString(requestIdStr), msg);
            ctx.tellSuccess(msg);
        }
    }

    public void destroy() {
    }
}

