/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.report;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.report.TbGenerateReportNodeConfiguration;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.blob.BlobEntity;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.report.ReportConfig;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ACTION, name="generate report", configClazz=TbGenerateReportNodeConfiguration.class, nodeDescription="Generates report", nodeDetails="Generates dashboard based reports.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeGenerateReportConfig", icon="description")
public class TbGenerateReportNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbGenerateReportNode.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String ATTACHMENTS = "attachments";
    private TbGenerateReportNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGenerateReportNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGenerateReportNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            ReportConfig reportConfig;
            if (this.config.isUseReportConfigFromMessage()) {
                try {
                    JsonNode msgJson = mapper.readTree(msg.getData());
                    JsonNode reportConfigJson = msgJson.get("reportConfig");
                    reportConfig = (ReportConfig)mapper.treeToValue((TreeNode)reportConfigJson, ReportConfig.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Incoming message doesn't contain valid reportConfig JSON configuration!", e);
                }
            } else {
                reportConfig = this.config.getReportConfig();
            }
            String reportsServerEndpointUrl = null;
            if (!this.config.isUseSystemReportsServer()) {
                reportsServerEndpointUrl = this.config.getReportsServerEndpointUrl();
            }
            ctx.getPeContext().getReportService().generateReport(ctx.getTenantId(), reportConfig, reportsServerEndpointUrl, reportData -> {
                User user = ctx.getUserService().findUserById(ctx.getTenantId(), new UserId(UUID.fromString(reportConfig.getUserId())));
                BlobEntity reportBlobEntity = new BlobEntity();
                reportBlobEntity.setData(ByteBuffer.wrap(reportData.getData()));
                reportBlobEntity.setContentType(reportData.getContentType());
                reportBlobEntity.setName(reportData.getName());
                reportBlobEntity.setType("report");
                reportBlobEntity.setTenantId(user.getTenantId());
                reportBlobEntity.setCustomerId(user.getCustomerId());
                reportBlobEntity = ctx.getPeContext().getBlobEntityService().saveBlobEntity(reportBlobEntity);
                TbMsgMetaData metaData = msg.getMetaData().copy();
                Object attachments = metaData.getValue(ATTACHMENTS);
                attachments = !StringUtils.isEmpty((Object)attachments) ? (String)attachments + "," + ((BlobEntityId)reportBlobEntity.getId()).toString() : ((BlobEntityId)reportBlobEntity.getId()).toString();
                metaData.putValue(ATTACHMENTS, (String)attachments);
                TbMsg newMsg = ctx.transformMsg(msg, msg.getType(), msg.getOriginator(), metaData, msg.getData());
                ctx.tellNext(newMsg, TbRelationTypes.SUCCESS);
            }, throwable -> ctx.tellFailure(msg, throwable));
        }
        catch (Exception e) {
            ctx.tellFailure(msg, (Throwable)e);
        }
    }

    public void destroy() {
    }
}

